/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.authc.cache;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ClearRealmCacheResponse
extends BaseNodesResponse<Node>
implements ToXContent {
    public ClearRealmCacheResponse() {
    }

    public ClearRealmCacheResponse(ClusterName clusterName, Node[] nodes) {
        super(clusterName, (BaseNodeResponse[])nodes);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new Node[in.readVInt()];
        for (int i = 0; i < ((Node[])this.nodes).length; ++i) {
            ((Node[])this.nodes)[i] = Node.readNodeResponse(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((Node[])this.nodes).length);
        for (Node node : (Node[])this.nodes) {
            node.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("cluster_name", this.getClusterName().value());
        builder.startObject("nodes");
        for (Node node : (Node[])this.getNodes()) {
            builder.startObject(node.getNode().id());
            builder.field("name", node.getNode().name());
            builder.endObject();
        }
        builder.endObject();
        return builder.endObject();
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public static class Node
    extends BaseNodeResponse {
        Node() {
        }

        Node(DiscoveryNode node) {
            super(node);
        }

        public static Node readNodeResponse(StreamInput in) throws IOException {
            Node node = new Node();
            node.readFrom(in);
            return node;
        }
    }
}

