/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.plugin.core.LicenseUtils;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.ShieldActionMapper;
import org.elasticsearch.shield.action.interceptor.RequestInterceptor;
import org.elasticsearch.shield.audit.AuditTrail;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.crypto.CryptoService;
import org.elasticsearch.shield.license.ShieldLicenseState;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;

public class ShieldActionFilter
extends AbstractComponent
implements ActionFilter {
    private static final Predicate<String> LICENSE_EXPIRATION_ACTION_MATCHER = Privilege.HEALTH_AND_STATS.predicate();
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final CryptoService cryptoService;
    private final AuditTrail auditTrail;
    private final ShieldActionMapper actionMapper;
    private final Set<RequestInterceptor> requestInterceptors;
    private final ShieldLicenseState licenseState;

    @Inject
    public ShieldActionFilter(Settings settings, AuthenticationService authcService, AuthorizationService authzService, CryptoService cryptoService, AuditTrail auditTrail, ShieldLicenseState licenseState, ShieldActionMapper actionMapper, Set<RequestInterceptor> requestInterceptors) {
        super(settings);
        this.authcService = authcService;
        this.authzService = authzService;
        this.cryptoService = cryptoService;
        this.auditTrail = auditTrail;
        this.actionMapper = actionMapper;
        this.licenseState = licenseState;
        this.requestInterceptors = requestInterceptors;
    }

    public void apply(String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        if (!this.licenseState.statsAndHealthEnabled() && LICENSE_EXPIRATION_ACTION_MATCHER.apply((Object)action)) {
            this.logger.error("blocking [{}] operation due to expired license. Cluster health, cluster stats and indices stats \noperations are blocked on shield license expiration. All data operations (read and write) continue to work. \nIf you have a new license, please update it. Otherwise, please reach out to your support contact.", new Object[]{action});
            throw LicenseUtils.newComplianceException((String)"shield");
        }
        try {
            if (this.licenseState.securityEnabled()) {
                String shieldAction = this.actionMapper.action(action, (TransportRequest)request);
                User user = this.authcService.authenticate(shieldAction, (TransportMessage)request, User.SYSTEM);
                this.authzService.authorize(user, shieldAction, (TransportRequest)request);
                request = this.unsign(user, shieldAction, request);
                for (RequestInterceptor interceptor : this.requestInterceptors) {
                    if (!interceptor.supports((TransportRequest)request)) continue;
                    interceptor.intercept(request, user);
                }
                chain.proceed(action, request, new SigningListener(this, listener));
            } else {
                chain.proceed(action, request, listener);
            }
        }
        catch (Throwable t) {
            listener.onFailure(t);
        }
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, response, listener);
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    <Request extends ActionRequest> Request unsign(User user, String action, Request request) {
        try {
            if (request instanceof SearchScrollRequest) {
                SearchScrollRequest scrollRequest = (SearchScrollRequest)request;
                String scrollId = scrollRequest.scrollId();
                scrollRequest.scrollId(this.cryptoService.unsignAndVerify(scrollId));
                return request;
            }
            if (request instanceof ClearScrollRequest) {
                ClearScrollRequest clearScrollRequest = (ClearScrollRequest)request;
                boolean isClearAllScrollRequest = clearScrollRequest.scrollIds().contains("_all");
                if (!isClearAllScrollRequest) {
                    List signedIds = clearScrollRequest.scrollIds();
                    ArrayList<String> unsignedIds = new ArrayList<String>(signedIds.size());
                    for (String signedId : signedIds) {
                        unsignedIds.add(this.cryptoService.unsignAndVerify(signedId));
                    }
                    clearScrollRequest.scrollIds(unsignedIds);
                }
                return request;
            }
            return request;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.auditTrail.tamperedRequest(user, action, (TransportMessage<?>)request);
            throw Exceptions.authorizationError("invalid request. {}", e.getMessage());
        }
    }

    <Response extends ActionResponse> Response sign(Response response) throws IOException {
        if (response instanceof SearchResponse) {
            SearchResponse searchResponse = (SearchResponse)response;
            String scrollId = searchResponse.getScrollId();
            if (scrollId != null && !this.cryptoService.signed(scrollId)) {
                searchResponse.scrollId(this.cryptoService.sign(scrollId));
            }
            return response;
        }
        return response;
    }

    static class SigningListener<Response extends ActionResponse>
    implements ActionListener<Response> {
        private final ShieldActionFilter filter;
        private final ActionListener innerListener;

        private SigningListener(ShieldActionFilter filter, ActionListener innerListener) {
            this.filter = filter;
            this.innerListener = innerListener;
        }

        public void onResponse(Response response) {
            try {
                response = this.filter.sign(response);
                this.innerListener.onResponse(response);
            }
            catch (IOException e) {
                this.onFailure(e);
            }
        }

        public void onFailure(Throwable e) {
            this.innerListener.onFailure(e);
        }
    }
}

