/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class User
implements ToXContent {
    public static final User SYSTEM = new System();

    public abstract String principal();

    public abstract String[] roles();

    public abstract User runAs();

    public final boolean isSystem() {
        return this == SYSTEM;
    }

    public static User readFrom(StreamInput input) throws IOException {
        if (input.readBoolean()) {
            String name = input.readString();
            if (!"__es_system_user".equals(name)) {
                throw new IllegalStateException("invalid system user");
            }
            return SYSTEM;
        }
        String username = input.readString();
        String[] roles = input.readStringArray();
        if (input.readBoolean()) {
            String runAsUsername = input.readString();
            String[] runAsRoles = input.readStringArray();
            return new Simple(username, roles, new Simple(runAsUsername, runAsRoles));
        }
        return new Simple(username, roles);
    }

    public static void writeTo(User user, StreamOutput output) throws IOException {
        if (user.isSystem()) {
            output.writeBoolean(true);
            output.writeString("__es_system_user");
            return;
        }
        output.writeBoolean(false);
        Simple simple = (Simple)user;
        output.writeString(simple.username);
        output.writeStringArray(simple.roles);
        if (simple.runAs == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeString(simple.runAs.principal());
            output.writeStringArray(simple.runAs.roles());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("username", this.principal());
        builder.array("roles", this.roles());
        builder.endObject();
        return builder;
    }

    private static class System
    extends User {
        private static final String NAME = "__es_system_user";
        private static final String[] ROLES = new String[]{"__es_system_role"};

        private System() {
        }

        @Override
        public String principal() {
            return NAME;
        }

        @Override
        public String[] roles() {
            return ROLES;
        }

        @Override
        public User runAs() {
            return null;
        }
    }

    public static class Simple
    extends User {
        private final String username;
        private final String[] roles;
        private final User runAs;

        public Simple(String username, String[] roles) {
            this(username, roles, null);
        }

        public Simple(String username, String[] roles, User runAs) {
            this.username = username;
            String[] stringArray = this.roles = roles == null ? Strings.EMPTY_ARRAY : roles;
            assert (runAs == null || runAs.runAs() == null) : "the runAs user should not be a user that can run as";
            if (runAs == SYSTEM) {
                throw new ElasticsearchSecurityException("the runAs user cannot be the internal system user", new Object[0]);
            }
            this.runAs = runAs;
        }

        @Override
        public String principal() {
            return this.username;
        }

        @Override
        public String[] roles() {
            return this.roles;
        }

        @Override
        public User runAs() {
            return this.runAs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Simple simple = (Simple)o;
            if (this.username != null ? !this.username.equals(simple.username) : simple.username != null) {
                return false;
            }
            if (!Arrays.equals(this.roles, simple.roles)) {
                return false;
            }
            return !(this.runAs != null ? !this.runAs.equals(simple.runAs) : simple.runAs != null);
        }

        public int hashCode() {
            int result = this.username != null ? this.username.hashCode() : 0;
            result = 31 * result + Arrays.hashCode(this.roles);
            result = 31 * result + (this.runAs != null ? this.runAs.hashCode() : 0);
            return result;
        }
    }
}

