/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.shield.audit.index.IndexAuditTrail;
import org.elasticsearch.threadpool.ThreadPool;

public class ShieldLifecycleService
extends AbstractComponent
implements ClusterStateListener {
    private final ThreadPool threadPool;
    private final IndexAuditTrail indexAuditTrail;

    @Inject
    public ShieldLifecycleService(Settings settings, ClusterService clusterService, ThreadPool threadPool, IndexAuditTrail indexAuditTrail) {
        super(settings);
        this.threadPool = threadPool;
        this.indexAuditTrail = indexAuditTrail;
        clusterService.add((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                ShieldLifecycleService.this.stop();
            }

            public void beforeClose() {
                ShieldLifecycleService.this.close();
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean master;
        if (this.indexAuditTrail.state() == IndexAuditTrail.State.INITIALIZED && this.indexAuditTrail.canStart(event, master = event.localNodeMaster())) {
            this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                public void onFailure(Throwable throwable) {
                    ShieldLifecycleService.this.logger.error("failed to start shield lifecycle services", throwable, new Object[0]);
                    assert (false) : "shield lifecycle services startup failed";
                }

                public void doRun() {
                    ShieldLifecycleService.this.indexAuditTrail.start(master);
                }
            });
        }
    }

    public void stop() {
        this.indexAuditTrail.stop();
    }

    public void close() {
        this.indexAuditTrail.close();
    }
}

