/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport.netty;

import java.util.LinkedList;
import java.util.Queue;
import org.elasticsearch.common.logging.ESLogger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.ssl.SslHandler;

public class HandshakeWaitingHandler
extends SimpleChannelHandler {
    private final ESLogger logger;
    private boolean handshaken = false;
    private Queue<MessageEvent> pendingWrites = new LinkedList<MessageEvent>();

    public HandshakeWaitingHandler(ESLogger logger) {
        this.logger = logger;
    }

    public void channelConnected(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
        final ChannelFuture handshakeFuture = sslHandler.handshake();
        handshakeFuture.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (handshakeFuture.isSuccess()) {
                    HandshakeWaitingHandler.this.logger.debug("SSL/TLS handshake completed for channel", new Object[0]);
                    HandshakeWaitingHandler handshakeWaitingHandler = HandshakeWaitingHandler.this;
                    synchronized (handshakeWaitingHandler) {
                        HandshakeWaitingHandler.this.handshaken = true;
                        while (!HandshakeWaitingHandler.this.pendingWrites.isEmpty()) {
                            MessageEvent event = (MessageEvent)HandshakeWaitingHandler.this.pendingWrites.remove();
                            ctx.sendDownstream((ChannelEvent)event);
                        }
                        ctx.getPipeline().remove(HandshakeWaitingHandler.class);
                    }
                    ctx.sendUpstream((ChannelEvent)e);
                } else {
                    Throwable cause = handshakeFuture.getCause();
                    if (HandshakeWaitingHandler.this.logger.isDebugEnabled()) {
                        HandshakeWaitingHandler.this.logger.debug("SSL/TLS handshake failed, closing channel: {}", cause, new Object[]{cause.getMessage()});
                    } else {
                        HandshakeWaitingHandler.this.logger.error("SSL/TLS handshake failed, closing channel: {}", new Object[]{cause.getMessage()});
                    }
                    HandshakeWaitingHandler handshakeWaitingHandler = HandshakeWaitingHandler.this;
                    synchronized (handshakeWaitingHandler) {
                        while (!HandshakeWaitingHandler.this.pendingWrites.isEmpty()) {
                            DownstreamMessageEvent event = (DownstreamMessageEvent)HandshakeWaitingHandler.this.pendingWrites.remove();
                            event.getFuture().setFailure(cause);
                        }
                        HandshakeWaitingHandler.this.pendingWrites = new SetFailureOnAddQueue(cause);
                        handshakeFuture.getChannel().close();
                    }
                }
            }
        });
    }

    public synchronized void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.handshaken) {
            this.pendingWrites.add(e);
            return;
        }
        ctx.sendDownstream((ChannelEvent)e);
    }

    synchronized boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    private static class SetFailureOnAddQueue
    extends LinkedList<MessageEvent> {
        private final Throwable cause;

        SetFailureOnAddQueue(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public boolean add(MessageEvent messageEvent) {
            DownstreamMessageEvent event = (DownstreamMessageEvent)messageEvent;
            event.getFuture().setFailure(this.cause);
            return false;
        }
    }
}

