/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.support;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.ShieldPlugin;

public abstract class AbstractShieldModule
extends AbstractModule {
    protected final Settings settings;
    protected final boolean clientMode;
    protected final boolean shieldEnabled;

    public AbstractShieldModule(Settings settings) {
        this.settings = settings;
        this.clientMode = !"node".equals(settings.get("client.type"));
        this.shieldEnabled = ShieldPlugin.shieldEnabled(settings);
    }

    protected final void configure() {
        this.configure(this.clientMode);
    }

    protected abstract void configure(boolean var1);

    public static abstract class Node
    extends AbstractShieldModule {
        protected Node(Settings settings) {
            super(settings);
        }

        @Override
        protected final void configure(boolean clientMode) {
            assert (!clientMode) : "[" + ((Object)((Object)this)).getClass().getSimpleName() + "] is a node only module";
            this.configureNode();
        }

        protected abstract void configureNode();
    }
}

