/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.support;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.Base64;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authc.support.CharArrays;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;

public class UsernamePasswordToken
implements AuthenticationToken {
    public static final String BASIC_AUTH_HEADER = "Authorization";
    private static final Pattern BASIC_AUTH_PATTERN = Pattern.compile("Basic\\s(.+)");
    private final String username;
    private final SecuredString password;

    public UsernamePasswordToken(String username, SecuredString password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public String principal() {
        return this.username;
    }

    @Override
    public SecuredString credentials() {
        return this.password;
    }

    @Override
    public void clearCredentials() {
        this.password.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePasswordToken that = (UsernamePasswordToken)o;
        return Objects.equals(this.password, that.password) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password.hashCode());
    }

    public static UsernamePasswordToken extractToken(TransportMessage<?> message, UsernamePasswordToken defaultToken) {
        String authStr = (String)message.getHeader(BASIC_AUTH_HEADER);
        if (authStr == null) {
            return defaultToken;
        }
        return UsernamePasswordToken.extractToken(authStr);
    }

    public static UsernamePasswordToken extractToken(RestRequest request, UsernamePasswordToken defaultToken) {
        String authStr = request.header(BASIC_AUTH_HEADER);
        if (authStr == null) {
            return defaultToken;
        }
        return UsernamePasswordToken.extractToken(authStr);
    }

    static UsernamePasswordToken extractToken(String token) {
        char[] userpasswd;
        Matcher matcher = BASIC_AUTH_PATTERN.matcher(token.trim());
        if (!matcher.matches()) {
            throw Exceptions.authenticationError("invalid basic authentication header value", new Object[0]);
        }
        try {
            userpasswd = CharArrays.utf8BytesToChars(Base64.decode((String)matcher.group(1)));
        }
        catch (IOException | IllegalArgumentException e) {
            throw Exceptions.authenticationError("invalid basic authentication header encoding", e, new Object[0]);
        }
        int i = CharArrays.indexOf(userpasswd, ':');
        if (i < 0) {
            throw Exceptions.authenticationError("invalid basic authentication header value", new Object[0]);
        }
        return new UsernamePasswordToken(new String(Arrays.copyOfRange(userpasswd, 0, i)), new SecuredString(Arrays.copyOfRange(userpasswd, i + 1, userpasswd.length)));
    }

    public static void putTokenHeader(TransportRequest request, UsernamePasswordToken token) {
        request.putHeader(BASIC_AUTH_HEADER, (Object)UsernamePasswordToken.basicAuthHeaderValue(token.username, token.password));
    }

    public static String basicAuthHeaderValue(String username, SecuredString passwd) {
        CharBuffer chars = CharBuffer.allocate(username.length() + passwd.length() + 1);
        chars.put(username).put(':').put(passwd.internalChars());
        String basicToken = Base64.encodeBytes((byte[])CharArrays.toUtf8Bytes(chars.array()));
        return "Basic " + basicToken;
    }
}

