/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.activedirectory;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.activedirectory.ActiveDirectorySessionFactory;
import org.elasticsearch.shield.authc.ldap.support.AbstractLdapRealm;
import org.elasticsearch.shield.authc.support.DnRoleMapper;
import org.elasticsearch.shield.ssl.ClientSSLService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class ActiveDirectoryRealm
extends AbstractLdapRealm {
    public static final String TYPE = "active_directory";

    public ActiveDirectoryRealm(RealmConfig config, ActiveDirectorySessionFactory connectionFactory, DnRoleMapper roleMapper) {
        super(TYPE, config, connectionFactory, roleMapper);
    }

    public static class Factory
    extends AbstractLdapRealm.Factory<ActiveDirectoryRealm> {
        private final ResourceWatcherService watcherService;
        private final ClientSSLService clientSSLService;

        @Inject
        public Factory(ResourceWatcherService watcherService, ClientSSLService clientSSLService) {
            super(ActiveDirectoryRealm.TYPE);
            this.watcherService = watcherService;
            this.clientSSLService = clientSSLService;
        }

        @Override
        public void filterOutSensitiveSettings(String realmName, ShieldSettingsFilter filter) {
            ActiveDirectorySessionFactory.filterOutSensitiveSettings(realmName, filter);
        }

        @Override
        public ActiveDirectoryRealm create(RealmConfig config) {
            ActiveDirectorySessionFactory connectionFactory = new ActiveDirectorySessionFactory(config, this.clientSSLService);
            DnRoleMapper roleMapper = new DnRoleMapper(ActiveDirectoryRealm.TYPE, config, this.watcherService, null);
            return new ActiveDirectoryRealm(config, connectionFactory, roleMapper);
        }
    }
}

