/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.authc.AnonymousService;
import org.elasticsearch.shield.authc.AuthenticationFailureHandler;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authc.DefaultAuthenticationFailureHandler;
import org.elasticsearch.shield.authc.InternalAuthenticationService;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.activedirectory.ActiveDirectoryRealm;
import org.elasticsearch.shield.authc.esusers.ESUsersRealm;
import org.elasticsearch.shield.authc.ldap.LdapRealm;
import org.elasticsearch.shield.authc.pki.PkiRealm;
import org.elasticsearch.shield.support.AbstractShieldModule;

public class AuthenticationModule
extends AbstractShieldModule.Node {
    static final List<String> INTERNAL_REALM_TYPES = Arrays.asList("esusers", "active_directory", "ldap", "pki");
    private final Map<String, Class<? extends Realm.Factory<? extends Realm<? extends AuthenticationToken>>>> customRealms = new HashMap<String, Class<? extends Realm.Factory<? extends Realm<? extends AuthenticationToken>>>>();
    private Class<? extends AuthenticationFailureHandler> authcFailureHandler = null;

    public AuthenticationModule(Settings settings) {
        super(settings);
    }

    @Override
    protected void configureNode() {
        MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Realm.Factory.class);
        mapBinder.addBinding((Object)"esusers").to(ESUsersRealm.Factory.class).asEagerSingleton();
        mapBinder.addBinding((Object)"active_directory").to(ActiveDirectoryRealm.Factory.class).asEagerSingleton();
        mapBinder.addBinding((Object)"ldap").to(LdapRealm.Factory.class).asEagerSingleton();
        mapBinder.addBinding((Object)"pki").to(PkiRealm.Factory.class).asEagerSingleton();
        for (Map.Entry<String, Class<? extends Realm.Factory<? extends Realm<? extends AuthenticationToken>>>> entry : this.customRealms.entrySet()) {
            mapBinder.addBinding((Object)entry.getKey()).to(entry.getValue()).asEagerSingleton();
        }
        this.bind(Realms.class).asEagerSingleton();
        this.bind(AnonymousService.class).asEagerSingleton();
        if (this.authcFailureHandler == null) {
            this.bind(AuthenticationFailureHandler.class).to(DefaultAuthenticationFailureHandler.class).asEagerSingleton();
        } else {
            this.bind(AuthenticationFailureHandler.class).to(this.authcFailureHandler).asEagerSingleton();
        }
        this.bind(AuthenticationService.class).to(InternalAuthenticationService.class).asEagerSingleton();
    }

    public void addCustomRealm(String type, Class<? extends Realm.Factory<? extends Realm<? extends AuthenticationToken>>> clazz) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("type must not be null or empty");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("realm factory class cannot be null");
        }
        if (INTERNAL_REALM_TYPES.contains(type)) {
            throw new IllegalArgumentException("cannot redefine the type [" + type + "] with custom realm [" + clazz.getName() + "]");
        }
        this.customRealms.put(type, clazz);
    }

    public void setAuthenticationFailureHandler(Class<? extends AuthenticationFailureHandler> clazz) {
        this.authcFailureHandler = clazz;
    }
}

