/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.interceptor;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;
import org.elasticsearch.shield.authz.accesscontrol.AccessControlShardModule;
import org.elasticsearch.transport.TransportRequest;

public class BulkRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor<BulkRequest> {
    @Inject
    public BulkRequestInterceptor(Settings settings) {
        super(settings);
    }

    @Override
    public void intercept(BulkRequest request, User user) {
        if (AccessControlShardModule.enabled(this.settings)) {
            this.disableFeatures(request);
        }
    }

    @Override
    protected void disableFeatures(BulkRequest bulkRequest) {
        for (ActionRequest actionRequest : bulkRequest.requests()) {
            if (!(actionRequest instanceof UpdateRequest)) continue;
            throw new ElasticsearchSecurityException("Can't execute an bulk request with update requests embedded if field or document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof BulkRequest;
    }
}

