/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.authc.cache;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.action.authc.cache.ClearRealmCacheRequest;
import org.elasticsearch.shield.action.authc.cache.ClearRealmCacheResponse;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.support.CachingRealm;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClearRealmCacheAction
extends TransportNodesAction<ClearRealmCacheRequest, ClearRealmCacheResponse, ClearRealmCacheRequest.Node, ClearRealmCacheResponse.Node> {
    private final Realms realms;

    @Inject
    public TransportClearRealmCacheAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Realms realms, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/shield/realm/cache/clear", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearRealmCacheRequest.class, ClearRealmCacheRequest.Node.class, "management");
        this.realms = realms;
    }

    protected ClearRealmCacheResponse newResponse(ClearRealmCacheRequest request, AtomicReferenceArray responses) {
        ArrayList<ClearRealmCacheResponse.Node> nodes = new ArrayList<ClearRealmCacheResponse.Node>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof ClearRealmCacheResponse.Node)) continue;
            nodes.add((ClearRealmCacheResponse.Node)((Object)resp));
        }
        return new ClearRealmCacheResponse(this.clusterName, nodes.toArray(new ClearRealmCacheResponse.Node[nodes.size()]));
    }

    protected ClearRealmCacheRequest.Node newNodeRequest(String nodeId, ClearRealmCacheRequest request) {
        return new ClearRealmCacheRequest.Node(request, nodeId);
    }

    protected ClearRealmCacheResponse.Node newNodeResponse() {
        return new ClearRealmCacheResponse.Node();
    }

    protected ClearRealmCacheResponse.Node nodeOperation(ClearRealmCacheRequest.Node nodeRequest) throws ElasticsearchException {
        if (nodeRequest.realms == null || nodeRequest.realms.length == 0) {
            for (Realm realm : this.realms) {
                this.clearCache(realm, nodeRequest.usernames);
            }
            return new ClearRealmCacheResponse.Node(this.clusterService.localNode());
        }
        for (String realmName : nodeRequest.realms) {
            Realm realm = this.realms.realm(realmName);
            if (realm == null) {
                throw new IllegalArgumentException("could not find active realm [" + realmName + "]");
            }
            this.clearCache(realm, nodeRequest.usernames);
        }
        return new ClearRealmCacheResponse.Node(this.clusterService.localNode());
    }

    private void clearCache(Realm realm, String[] usernames) {
        if (!(realm instanceof CachingRealm)) {
            return;
        }
        CachingRealm cachingRealm = (CachingRealm)((Object)realm);
        if (usernames != null && usernames.length != 0) {
            for (String username : usernames) {
                cachingRealm.expire(username);
            }
        } else {
            cachingRealm.expireAll();
        }
    }

    protected boolean accumulateExceptions() {
        return false;
    }
}

