/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.index.cache.IndexCacheModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.shield.ShieldDisabledModule;
import org.elasticsearch.shield.ShieldModule;
import org.elasticsearch.shield.action.ShieldActionFilter;
import org.elasticsearch.shield.action.ShieldActionModule;
import org.elasticsearch.shield.action.authc.cache.ClearRealmCacheAction;
import org.elasticsearch.shield.action.authc.cache.TransportClearRealmCacheAction;
import org.elasticsearch.shield.audit.AuditTrailModule;
import org.elasticsearch.shield.audit.index.IndexAuditUserHolder;
import org.elasticsearch.shield.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.shield.authc.AuthenticationModule;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;
import org.elasticsearch.shield.authz.AuthorizationModule;
import org.elasticsearch.shield.authz.accesscontrol.AccessControlShardModule;
import org.elasticsearch.shield.authz.accesscontrol.OptOutQueryCache;
import org.elasticsearch.shield.authz.store.FileRolesStore;
import org.elasticsearch.shield.crypto.CryptoModule;
import org.elasticsearch.shield.crypto.InternalCryptoService;
import org.elasticsearch.shield.license.LicenseModule;
import org.elasticsearch.shield.license.ShieldLicensee;
import org.elasticsearch.shield.rest.ShieldRestModule;
import org.elasticsearch.shield.rest.action.RestShieldInfoAction;
import org.elasticsearch.shield.rest.action.authc.cache.RestClearRealmCacheAction;
import org.elasticsearch.shield.ssl.SSLModule;
import org.elasticsearch.shield.transport.ShieldClientTransportService;
import org.elasticsearch.shield.transport.ShieldServerTransportService;
import org.elasticsearch.shield.transport.ShieldTransportModule;
import org.elasticsearch.shield.transport.filter.IPFilter;
import org.elasticsearch.shield.transport.netty.ShieldNettyHttpServerTransport;
import org.elasticsearch.shield.transport.netty.ShieldNettyTransport;
import org.elasticsearch.transport.TransportModule;

public class ShieldPlugin
extends Plugin {
    public static final String NAME = "shield";
    public static final String ENABLED_SETTING_NAME = "shield.enabled";
    public static final String OPT_OUT_QUERY_CACHE = "opt_out_cache";
    private static final boolean DEFAULT_ENABLED_SETTING = true;
    private final Settings settings;
    private final boolean enabled;
    private final boolean clientMode;

    public ShieldPlugin(Settings settings) {
        this.settings = settings;
        this.enabled = ShieldPlugin.shieldEnabled(settings);
        this.clientMode = ShieldPlugin.clientMode(settings);
        if (this.enabled && !this.clientMode) {
            this.failIfShieldQueryCacheIsNotActive(settings, true);
        }
    }

    public String name() {
        return NAME;
    }

    public String description() {
        return "Elasticsearch Shield (security)";
    }

    public Collection<Module> nodeModules() {
        if (!this.enabled) {
            return Collections.singletonList(new ShieldDisabledModule(this.settings));
        }
        if (this.clientMode) {
            return Arrays.asList(new Module[]{new ShieldTransportModule(this.settings), new SSLModule(this.settings)});
        }
        return Arrays.asList(new Module[]{new ShieldModule(this.settings), new LicenseModule(this.settings), new CryptoModule(this.settings), new AuthenticationModule(this.settings), new AuthorizationModule(this.settings), new AuditTrailModule(this.settings), new ShieldRestModule(this.settings), new ShieldActionModule(this.settings), new ShieldTransportModule(this.settings), new SSLModule(this.settings)});
    }

    public Collection<Module> indexModules(Settings settings) {
        if (this.enabled && !this.clientMode) {
            this.failIfShieldQueryCacheIsNotActive(settings, false);
        }
        return Collections.emptyList();
    }

    public Collection<Module> shardModules(Settings settings) {
        if (this.enabled && !this.clientMode) {
            this.failIfShieldQueryCacheIsNotActive(settings, false);
            return Collections.singletonList(new AccessControlShardModule(settings));
        }
        return Collections.emptyList();
    }

    public Collection<Class<? extends LifecycleComponent>> nodeServices() {
        if (this.enabled && !this.clientMode) {
            ArrayList<Class<? extends LifecycleComponent>> list = new ArrayList<Class<? extends LifecycleComponent>>();
            if (AuditTrailModule.fileAuditLoggingEnabled(this.settings)) {
                list.add(LoggingAuditTrail.class);
            }
            list.add(ShieldLicensee.class);
            list.add(InternalCryptoService.class);
            list.add(FileRolesStore.class);
            list.add(Realms.class);
            list.add(IPFilter.class);
            return list;
        }
        return Collections.emptyList();
    }

    public Settings additionalSettings() {
        if (!this.enabled) {
            return Settings.EMPTY;
        }
        Settings.Builder settingsBuilder = Settings.settingsBuilder();
        this.addUserSettings(settingsBuilder);
        this.addTribeSettings(settingsBuilder);
        this.addQueryCacheSettings(settingsBuilder);
        return settingsBuilder.build();
    }

    public void onModule(ClusterModule clusterDynamicSettingsModule) {
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.transport.filter.*", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.http.filter.*", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("transport.profiles.*", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.transport.filter.enabled", Validator.EMPTY);
        clusterDynamicSettingsModule.registerClusterDynamicSetting("shield.http.filter.enabled", Validator.EMPTY);
    }

    public void onModule(ActionModule module) {
        if (!this.enabled) {
            return;
        }
        if (!this.clientMode) {
            module.registerFilter(ShieldActionFilter.class);
        }
        module.registerAction((GenericAction)ClearRealmCacheAction.INSTANCE, TransportClearRealmCacheAction.class, new Class[0]);
    }

    public void onModule(TransportModule module) {
        if (!this.enabled) {
            return;
        }
        module.setTransport(ShieldNettyTransport.class, NAME);
        if (this.clientMode) {
            module.setTransportService(ShieldClientTransportService.class, NAME);
        } else {
            module.setTransportService(ShieldServerTransportService.class, NAME);
        }
    }

    public void onModule(HttpServerModule module) {
        if (this.enabled && !this.clientMode) {
            module.setHttpServerTransport(ShieldNettyHttpServerTransport.class, NAME);
        }
    }

    public void onModule(RestModule module) {
        if (this.enabled && !this.clientMode) {
            module.addRestAction(RestClearRealmCacheAction.class);
        }
        module.addRestAction(RestShieldInfoAction.class);
    }

    public void onModule(AuthorizationModule module) {
        if (this.enabled && AuditTrailModule.auditingEnabled(this.settings)) {
            module.registerReservedRole(IndexAuditUserHolder.ROLE);
        }
    }

    public void onModule(IndexCacheModule module) {
        if (this.enabled && !this.clientMode) {
            module.registerQueryCache(OPT_OUT_QUERY_CACHE, OptOutQueryCache.class);
        }
    }

    private void addUserSettings(Settings.Builder settingsBuilder) {
        String authHeaderSettingName = "request.headers.Authorization";
        if (this.settings.get(authHeaderSettingName) != null) {
            return;
        }
        String userSetting = this.settings.get("shield.user");
        if (userSetting == null) {
            return;
        }
        int i = userSetting.indexOf(":");
        if (i < 0 || i == userSetting.length() - 1) {
            throw new IllegalArgumentException("invalid [shield.user] setting. must be in the form of \"<username>:<password>\"");
        }
        String username = userSetting.substring(0, i);
        String password = userSetting.substring(i + 1);
        settingsBuilder.put(authHeaderSettingName, UsernamePasswordToken.basicAuthHeaderValue(username, new SecuredString(password.toCharArray())));
    }

    private void addTribeSettings(Settings.Builder settingsBuilder) {
        Map tribesSettings = this.settings.getGroups("tribe", true);
        if (tribesSettings.isEmpty()) {
            return;
        }
        for (Map.Entry tribeSettings : tribesSettings.entrySet()) {
            String tribePrefix = "tribe." + (String)tribeSettings.getKey() + ".";
            String[] existingMandatoryPlugins = ((Settings)tribeSettings.getValue()).getAsArray("plugin.mandatory", null);
            if (existingMandatoryPlugins == null) {
                settingsBuilder.putArray(tribePrefix + "plugin.mandatory", new String[]{NAME});
            } else if (!ShieldPlugin.isShieldMandatory(existingMandatoryPlugins)) {
                throw new IllegalStateException("when [plugin.mandatory] is explicitly configured, [shield] must be included in this list");
            }
            String tribeEnabledSetting = tribePrefix + ENABLED_SETTING_NAME;
            if (this.settings.get(tribeEnabledSetting) != null) {
                boolean enabled = ShieldPlugin.shieldEnabled((Settings)tribeSettings.getValue());
                if (enabled) continue;
                throw new IllegalStateException("tribe setting [" + tribeEnabledSetting + "] must be set to true but the value is [" + this.settings.get(tribeEnabledSetting) + "]");
            }
            settingsBuilder.put(tribeEnabledSetting, true);
        }
    }

    private void addQueryCacheSettings(Settings.Builder settingsBuilder) {
        settingsBuilder.put("index.queries.cache.type", OPT_OUT_QUERY_CACHE);
    }

    private static boolean isShieldMandatory(String[] existingMandatoryPlugins) {
        for (String existingMandatoryPlugin : existingMandatoryPlugins) {
            if (!NAME.equals(existingMandatoryPlugin)) continue;
            return true;
        }
        return false;
    }

    public static Path configDir(Environment env) {
        return env.configFile().resolve(NAME);
    }

    public static Path resolveConfigFile(Environment env, String name) {
        return ShieldPlugin.configDir(env).resolve(name);
    }

    public static boolean clientMode(Settings settings) {
        return !"node".equals(settings.get("client.type"));
    }

    public static boolean shieldEnabled(Settings settings) {
        return settings.getAsBoolean(ENABLED_SETTING_NAME, Boolean.valueOf(true));
    }

    private void failIfShieldQueryCacheIsNotActive(Settings settings, boolean nodeSettings) {
        String queryCacheImplementation = nodeSettings ? settings.get("index.queries.cache.type", OPT_OUT_QUERY_CACHE) : settings.get("index.queries.cache.type");
        if (!OPT_OUT_QUERY_CACHE.equals(queryCacheImplementation)) {
            throw new IllegalStateException("shield does not support a user specified query cache. remove the setting [index.queries.cache.type] with value [" + queryCacheImplementation + "]");
        }
    }
}

