/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;

public class RemoteHostHeader {
    static final String KEY = "_rest_remote_address";

    public static void process(RestRequest request) {
        request.putInContext((Object)KEY, (Object)request.getRemoteAddress());
    }

    public static InetSocketAddress restRemoteAddress(TransportMessage message) {
        SocketAddress address = (SocketAddress)message.getFromContext((Object)KEY);
        if (address != null && address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    public static void putRestRemoteAddress(TransportMessage message, SocketAddress address) {
        message.putInContext((Object)KEY, (Object)address);
    }
}

