/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.indicesresolver;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.authz.indicesresolver.IndicesAndAliasesResolver;
import org.elasticsearch.transport.TransportRequest;

public class DefaultIndicesAndAliasesResolver
implements IndicesAndAliasesResolver<TransportRequest> {
    private final AuthorizationService authzService;

    public DefaultIndicesAndAliasesResolver(AuthorizationService authzService) {
        this.authzService = authzService;
    }

    @Override
    public Class<TransportRequest> requestType() {
        return TransportRequest.class;
    }

    @Override
    public Set<String> resolve(User user, String action, TransportRequest request, MetaData metaData) {
        boolean isIndicesRequest;
        boolean bl = isIndicesRequest = request instanceof CompositeIndicesRequest || request instanceof IndicesRequest;
        assert (isIndicesRequest) : "Request [" + request + "] is not an Indices request. The only requests passing the action matcher should be IndicesRequests";
        if (!isIndicesRequest) {
            return Collections.emptySet();
        }
        if (request instanceof CompositeIndicesRequest) {
            HashSet indices = Sets.newHashSet();
            CompositeIndicesRequest compositeIndicesRequest = (CompositeIndicesRequest)request;
            for (IndicesRequest indicesRequest : compositeIndicesRequest.subRequests()) {
                indices.addAll(this.resolveIndicesAndAliases(user, action, indicesRequest, metaData));
            }
            return indices;
        }
        return this.resolveIndicesAndAliases(user, action, (IndicesRequest)request, metaData);
    }

    private Set<String> resolveIndicesAndAliases(User user, String action, IndicesRequest indicesRequest, MetaData metaData) {
        if (indicesRequest.indicesOptions().expandWildcardsOpen() || indicesRequest.indicesOptions().expandWildcardsClosed()) {
            if (indicesRequest instanceof IndicesRequest.Replaceable) {
                List<String> authorizedIndices = this.authzService.authorizedIndicesAndAliases(user, action);
                List<String> indices = this.replaceWildcardsWithAuthorizedIndices(indicesRequest.indices(), indicesRequest.indicesOptions(), metaData, authorizedIndices);
                ((IndicesRequest.Replaceable)indicesRequest).indices(indices.toArray(new String[indices.size()]));
            } else assert (!this.containsWildcards(indicesRequest)) : "There are no external requests known to support wildcards that don't support replacing their indices";
        }
        HashSet indices = Sets.newHashSet((Object[])indicesRequest.indices());
        if (indicesRequest instanceof AliasesRequest) {
            AliasesRequest aliasesRequest = (AliasesRequest)indicesRequest;
            if (aliasesRequest.expandAliasesWildcards()) {
                List<String> authorizedIndices = this.authzService.authorizedIndicesAndAliases(user, action);
                List<String> aliases = this.replaceWildcardsWithAuthorizedAliases(aliasesRequest.aliases(), this.loadAuthorizedAliases(authorizedIndices, metaData));
                aliasesRequest.aliases(aliases.toArray(new String[aliases.size()]));
            }
            Collections.addAll(indices, aliasesRequest.aliases());
        }
        return indices;
    }

    private List<String> loadAuthorizedAliases(List<String> authorizedIndices, MetaData metaData) {
        ArrayList<String> authorizedAliases = new ArrayList<String>();
        SortedMap existingAliases = metaData.getAliasAndIndexLookup();
        for (String authorizedIndex : authorizedIndices) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)existingAliases.get(authorizedIndex);
            if (aliasOrIndex == null || !aliasOrIndex.isAlias()) continue;
            authorizedAliases.add(authorizedIndex);
        }
        return authorizedAliases;
    }

    private List<String> replaceWildcardsWithAuthorizedAliases(String[] aliases, List<String> authorizedAliases) {
        boolean matchAllAliases;
        ArrayList<String> finalAliases = new ArrayList<String>();
        boolean bl = matchAllAliases = aliases.length == 0;
        if (matchAllAliases) {
            finalAliases.addAll(authorizedAliases);
        }
        for (String aliasPattern : aliases) {
            if (aliasPattern.equals("_all")) {
                matchAllAliases = true;
                finalAliases.addAll(authorizedAliases);
                continue;
            }
            if (Regex.isSimpleMatchPattern((String)aliasPattern)) {
                for (String authorizedAlias : authorizedAliases) {
                    if (!Regex.simpleMatch((String)aliasPattern, (String)authorizedAlias)) continue;
                    finalAliases.add(authorizedAlias);
                }
                continue;
            }
            finalAliases.add(aliasPattern);
        }
        if (finalAliases.isEmpty()) {
            Index index = matchAllAliases ? new Index("_all") : new Index(Arrays.toString(aliases));
            throw new IndexNotFoundException(index.getName());
        }
        return finalAliases;
    }

    private boolean containsWildcards(IndicesRequest indicesRequest) {
        if (IndexNameExpressionResolver.isAllIndices(DefaultIndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
            return true;
        }
        for (String index : indicesRequest.indices()) {
            if (!index.startsWith("+") && !index.startsWith("-") && !Regex.isSimpleMatchPattern((String)index)) continue;
            return true;
        }
        return false;
    }

    private List<String> replaceWildcardsWithAuthorizedIndices(String[] indices, IndicesOptions indicesOptions, MetaData metaData, List<String> authorizedIndices) {
        if (IndexNameExpressionResolver.isAllIndices(DefaultIndicesAndAliasesResolver.indicesList(indices))) {
            ArrayList<String> visibleIndices = new ArrayList<String>();
            for (String authorizedIndex : authorizedIndices) {
                if (!DefaultIndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                visibleIndices.add(authorizedIndex);
            }
            return this.throwExceptionIfNoIndicesWereResolved(indices, visibleIndices);
        }
        ArrayList<String> finalIndices = new ArrayList<String>();
        for (int i = 0; i < indices.length; ++i) {
            String aliasOrIndex;
            String index = indices[i];
            boolean minus = false;
            if (index.charAt(0) == '+') {
                aliasOrIndex = index.substring(1);
            } else if (index.charAt(0) == '-') {
                if (i == 0) {
                    for (String authorizedIndex : authorizedIndices) {
                        if (!DefaultIndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                        finalIndices.add(authorizedIndex);
                    }
                }
                aliasOrIndex = index.substring(1);
                minus = true;
            } else {
                aliasOrIndex = index;
            }
            if (Regex.isSimpleMatchPattern((String)aliasOrIndex)) {
                for (String authorizedIndex : authorizedIndices) {
                    if (!Regex.simpleMatch((String)aliasOrIndex, (String)authorizedIndex)) continue;
                    if (minus) {
                        finalIndices.remove(authorizedIndex);
                        continue;
                    }
                    if (!DefaultIndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                    finalIndices.add(authorizedIndex);
                }
                continue;
            }
            if (minus) {
                finalIndices.remove(aliasOrIndex);
                continue;
            }
            finalIndices.add(aliasOrIndex);
        }
        return this.throwExceptionIfNoIndicesWereResolved(indices, finalIndices);
    }

    private List<String> throwExceptionIfNoIndicesWereResolved(String[] originalIndices, List<String> resolvedIndices) {
        if (resolvedIndices == null || resolvedIndices.isEmpty()) {
            Index index = IndexNameExpressionResolver.isAllIndices(DefaultIndicesAndAliasesResolver.indicesList(originalIndices)) ? new Index("_all") : new Index(Arrays.toString(originalIndices));
            throw new IndexNotFoundException(index.getName());
        }
        return resolvedIndices;
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData) {
        if (metaData.hasConcreteIndex(index)) {
            IndexMetaData indexMetaData = metaData.index(index);
            if (indexMetaData == null) {
                return true;
            }
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE && indicesOptions.expandWildcardsClosed()) {
                return true;
            }
            if (indexMetaData.getState() == IndexMetaData.State.OPEN && indicesOptions.expandWildcardsOpen()) {
                return true;
            }
        }
        return false;
    }

    private static List<String> indicesList(String[] list) {
        return list == null ? null : Arrays.asList(list);
    }
}

