/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.authz.AuthorizationService;
import org.elasticsearch.shield.authz.InternalAuthorizationService;
import org.elasticsearch.shield.authz.Permission;
import org.elasticsearch.shield.authz.store.FileRolesStore;
import org.elasticsearch.shield.authz.store.RolesStore;
import org.elasticsearch.shield.support.AbstractShieldModule;

public class AuthorizationModule
extends AbstractShieldModule.Node {
    private final Set<Permission.Global.Role> reservedRoles = new HashSet<Permission.Global.Role>();

    public AuthorizationModule(Settings settings) {
        super(settings);
    }

    public void registerReservedRole(Permission.Global.Role role) {
        this.reservedRoles.add(role);
    }

    @Override
    protected void configureNode() {
        Multibinder reservedRolesBinder = Multibinder.newSetBinder((Binder)this.binder(), Permission.Global.Role.class);
        for (Permission.Global.Role reservedRole : this.reservedRoles) {
            reservedRolesBinder.addBinding().toInstance((Object)reservedRole);
        }
        this.bind(FileRolesStore.class).asEagerSingleton();
        this.bind(RolesStore.class).to(FileRolesStore.class).asEagerSingleton();
        this.bind(AuthorizationService.class).to(InternalAuthorizationService.class).asEagerSingleton();
    }
}

