/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.shield.authc.AuthenticationFailureHandler;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.support.Exceptions;
import org.elasticsearch.transport.TransportMessage;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    @Override
    public ElasticsearchSecurityException unsuccessfulAuthentication(RestRequest request, AuthenticationToken token) {
        return Exceptions.authenticationError("unable to authenticate user [{}] for REST request [{}]", token.principal(), request.uri());
    }

    @Override
    public ElasticsearchSecurityException unsuccessfulAuthentication(TransportMessage message, AuthenticationToken token, String action) {
        return Exceptions.authenticationError("unable to authenticate user [{}] for action [{}]", token.principal(), action);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(RestRequest request, Exception e) {
        if (e instanceof ElasticsearchSecurityException) {
            assert (((ElasticsearchSecurityException)e).status() == RestStatus.UNAUTHORIZED);
            assert (((ElasticsearchSecurityException)e).getHeader("WWW-Authenticate").size() == 1);
            return (ElasticsearchSecurityException)e;
        }
        return Exceptions.authenticationError("error attempting to authenticate request", e, new Object[0]);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(TransportMessage message, Exception e) {
        if (e instanceof ElasticsearchSecurityException) {
            assert (((ElasticsearchSecurityException)e).status() == RestStatus.UNAUTHORIZED);
            assert (((ElasticsearchSecurityException)e).getHeader("WWW-Authenticate").size() == 1);
            return (ElasticsearchSecurityException)e;
        }
        return Exceptions.authenticationError("error attempting to authenticate request", e, new Object[0]);
    }

    @Override
    public ElasticsearchSecurityException missingToken(RestRequest request) {
        return Exceptions.authenticationError("missing authentication token for REST request [{}]", request.uri());
    }

    @Override
    public ElasticsearchSecurityException missingToken(TransportMessage message, String action) {
        return Exceptions.authenticationError("missing authentication token for action [{}]", action);
    }

    @Override
    public ElasticsearchSecurityException authenticationRequired(String action) {
        return Exceptions.authenticationError("action [{}] requires authentication", action);
    }
}

