/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport.netty;

import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.http.netty.NettyHttpServerTransport;
import org.elasticsearch.shield.ssl.ServerSSLService;
import org.elasticsearch.shield.transport.SSLClientAuth;
import org.elasticsearch.shield.transport.SSLExceptionHelper;
import org.elasticsearch.shield.transport.filter.IPFilter;
import org.elasticsearch.shield.transport.netty.IPFilterNettyUpstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.ssl.SslHandler;

public class ShieldNettyHttpServerTransport
extends NettyHttpServerTransport {
    public static final String HTTP_SSL_SETTING = "shield.http.ssl";
    public static final boolean HTTP_SSL_DEFAULT = false;
    public static final String HTTP_CLIENT_AUTH_SETTING = "shield.http.ssl.client.auth";
    public static final SSLClientAuth HTTP_CLIENT_AUTH_DEFAULT = SSLClientAuth.NO;
    private final IPFilter ipFilter;
    private final ServerSSLService sslService;
    private final boolean ssl;

    @Inject
    public ShieldNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, IPFilter ipFilter, ServerSSLService sslService) {
        super(settings, networkService, bigArrays);
        this.ipFilter = ipFilter;
        this.ssl = settings.getAsBoolean(HTTP_SSL_SETTING, Boolean.valueOf(false));
        this.sslService = sslService;
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.lifecycle.started()) {
            return;
        }
        Throwable t = e.getCause();
        if (SSLExceptionHelper.isNotSslRecordException(t)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("received plaintext http traffic on a https channel, closing connection {}", t, new Object[]{ctx.getChannel()});
            } else {
                this.logger.warn("received plaintext http traffic on a https channel, closing connection {}", new Object[]{ctx.getChannel()});
            }
            ctx.getChannel().close();
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(t)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("connection {} closed during handshake", t, new Object[]{ctx.getChannel()});
            } else {
                this.logger.warn("connection {} closed during handshake", new Object[]{ctx.getChannel()});
            }
            ctx.getChannel().close();
        } else {
            super.exceptionCaught(ctx, e);
        }
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new HttpSslChannelPipelineFactory(this);
    }

    private class HttpSslChannelPipelineFactory
    extends NettyHttpServerTransport.HttpChannelPipelineFactory {
        private final SSLClientAuth clientAuth;

        public HttpSslChannelPipelineFactory(NettyHttpServerTransport transport) {
            super(transport, ShieldNettyHttpServerTransport.this.detailedErrorsEnabled);
            this.clientAuth = SSLClientAuth.parse(ShieldNettyHttpServerTransport.this.settings.get(ShieldNettyHttpServerTransport.HTTP_CLIENT_AUTH_SETTING), HTTP_CLIENT_AUTH_DEFAULT);
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (ShieldNettyHttpServerTransport.this.ssl) {
                SSLEngine engine = ShieldNettyHttpServerTransport.this.sslService.createSSLEngine();
                engine.setUseClientMode(false);
                this.clientAuth.configure(engine);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(engine));
            }
            pipeline.addFirst("ipfilter", (ChannelHandler)new IPFilterNettyUpstreamHandler(ShieldNettyHttpServerTransport.this.ipFilter, ".http"));
            return pipeline;
        }
    }
}

