/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;

public interface ClientTransportFilter {
    public void outbound(String var1, TransportRequest var2) throws IOException;

    public static class Node
    implements ClientTransportFilter {
        private final AuthenticationService authcService;

        @Inject
        public Node(AuthenticationService authcService) {
            this.authcService = authcService;
        }

        @Override
        public void outbound(String action, TransportRequest request) throws IOException {
            this.authcService.attachUserHeaderIfMissing((TransportMessage)request, User.SYSTEM);
        }
    }

    public static class TransportClient
    implements ClientTransportFilter {
        @Override
        public void outbound(String action, TransportRequest request) {
        }
    }
}

