/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.crypto.tool;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.elasticsearch.common.cli.CheckFileCommand;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.crypto.InternalCryptoService;

public class SystemKeyTool
extends CliTool {
    public static final Set<PosixFilePermission> PERMISSION_OWNER_READ_WRITE = Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});
    private static final CliToolConfig CONFIG = CliToolConfig.config((String)"syskey", SystemKeyTool.class).cmds(new CliToolConfig.Cmd[]{Generate.access$000()}).build();

    public static void main(String[] args) throws Exception {
        CliTool.ExitStatus exitStatus = new SystemKeyTool().execute(args);
        System.exit(exitStatus.status());
    }

    public SystemKeyTool() {
        super(CONFIG);
    }

    protected CliTool.Command parse(String cmd, CommandLine commandLine) throws Exception {
        return Generate.parse(this.terminal, commandLine, this.env);
    }

    static class Generate
    extends CheckFileCommand {
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"generate", Generate.class).build();
        final Path path;

        Generate(Terminal terminal, Path path) {
            super(terminal);
            this.path = path;
        }

        public static CliTool.Command parse(Terminal terminal, CommandLine cl, Environment env) {
            String[] args = cl.getArgs();
            if (args.length > 1) {
                return SystemKeyTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"Too many arguments", (Object[])new Object[0]);
            }
            Path path = args.length != 0 ? env.binFile().getParent().resolve(args[0]) : null;
            return new Generate(terminal, path);
        }

        protected Path[] pathsForPermissionsCheck(Settings settings, Environment env) {
            Path path = this.path;
            if (path == null) {
                path = InternalCryptoService.resolveSystemKey(settings, env);
            }
            return new Path[]{path};
        }

        public CliTool.ExitStatus doExecute(Settings settings, Environment env) throws Exception {
            Path path = this.path;
            try {
                if (path == null) {
                    path = InternalCryptoService.resolveSystemKey(settings, env);
                }
                this.terminal.println(Terminal.Verbosity.VERBOSE, "generating...", new Object[0]);
                byte[] key = InternalCryptoService.generateKey();
                this.terminal.println("Storing generated key in [%s]...", new Object[]{path.toAbsolutePath()});
                Files.write(path, key, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException ioe) {
                this.terminal.printError("Cannot generate and save system key file [%s]", new Object[]{path.toAbsolutePath()});
                return CliTool.ExitStatus.IO_ERROR;
            }
            boolean supportsPosixPermissions = Environment.getFileStore((Path)path).supportsFileAttributeView(PosixFileAttributeView.class);
            if (supportsPosixPermissions) {
                try {
                    Files.setPosixFilePermissions(path, PERMISSION_OWNER_READ_WRITE);
                }
                catch (IOException ioe) {
                    this.terminal.printError("Cannot set owner read/write permissions to generated system key file [%s]", new Object[]{path.toAbsolutePath()});
                    return CliTool.ExitStatus.IO_ERROR;
                }
                this.terminal.println("Ensure the generated key can be read by the user that Elasticsearch runs as, permissions are set to owner read/write only", new Object[0]);
            }
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$000() {
            return CMD;
        }
    }
}

