/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.store;

import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.YAMLException;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.authc.support.RefreshListener;
import org.elasticsearch.shield.authz.Permission;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.authz.accesscontrol.AccessControlShardModule;
import org.elasticsearch.shield.authz.store.RolesStore;
import org.elasticsearch.shield.support.NoOpLogger;
import org.elasticsearch.shield.support.Validation;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;

public class FileRolesStore
extends AbstractLifecycleComponent<RolesStore>
implements RolesStore {
    private static final Pattern COMMA_DELIM = Pattern.compile("\\s*,\\s*");
    private static final Pattern IN_SEGMENT_LINE = Pattern.compile("^\\s+.+");
    private static final Pattern SKIP_LINE = Pattern.compile("(^#.*|^\\s*)");
    private final Path file;
    private final RefreshListener listener;
    private final ImmutableSet<Permission.Global.Role> reservedRoles;
    private final ResourceWatcherService watcherService;
    private volatile ImmutableMap<String, Permission.Global.Role> permissions;

    @Inject
    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, Set<Permission.Global.Role> reservedRoles) {
        this(settings, env, watcherService, reservedRoles, RefreshListener.NOOP);
    }

    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, Set<Permission.Global.Role> reservedRoles, RefreshListener listener) {
        super(settings);
        this.file = FileRolesStore.resolveFile(settings, env);
        this.listener = listener;
        this.watcherService = watcherService;
        this.reservedRoles = ImmutableSet.copyOf(reservedRoles);
        this.permissions = ImmutableMap.of();
    }

    protected void doStart() throws ElasticsearchException {
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            this.watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to setup roles file watcher", (Throwable)e, new Object[0]);
        }
        this.permissions = FileRolesStore.parseFile(this.file, this.reservedRoles, this.logger, this.settings);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public Permission.Global.Role role(String role) {
        return (Permission.Global.Role)this.permissions.get((Object)role);
    }

    public static Path resolveFile(Settings settings, Environment env) {
        String location = settings.get("shield.authz.store.files.roles");
        if (location == null) {
            return ShieldPlugin.resolveConfigFile(env, "roles.yml");
        }
        return env.binFile().getParent().resolve(location);
    }

    public static ImmutableSet<String> parseFileForRoleNames(Path path, ESLogger logger) {
        ImmutableMap<String, Permission.Global.Role> roleMap = FileRolesStore.parseFile(path, Collections.emptySet(), logger, false, Settings.EMPTY);
        if (roleMap == null) {
            return ImmutableSet.builder().build();
        }
        return roleMap.keySet();
    }

    public static ImmutableMap<String, Permission.Global.Role> parseFile(Path path, Set<Permission.Global.Role> reservedRoles, ESLogger logger, Settings settings) {
        return FileRolesStore.parseFile(path, reservedRoles, logger, true, settings);
    }

    public static ImmutableMap<String, Permission.Global.Role> parseFile(Path path, Set<Permission.Global.Role> reservedRoles, ESLogger logger, boolean resolvePermission, Settings settings) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, Permission.Global.Role> roles = new HashMap<String, Permission.Global.Role>();
        logger.trace("attempted to read roles file located at [{}]", new Object[]{path.toAbsolutePath()});
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                for (String segment : roleSegments) {
                    Permission.Global.Role role = FileRolesStore.parseRole(segment, path, logger, resolvePermission, settings);
                    if (role == null) continue;
                    if ("__es_system_role".equals(role.name())) {
                        logger.warn("role [{}] is reserved to the system. the relevant role definition in the mapping file will be ignored", new Object[]{"__es_system_role"});
                        continue;
                    }
                    roles.put(role.name(), role);
                }
            }
            catch (IOException ioe) {
                logger.error("failed to read roles file [{}]. skipping all roles...", (Throwable)ioe, new Object[]{path.toAbsolutePath()});
            }
        }
        for (Permission.Global.Role reservedRole : reservedRoles) {
            if (roles.containsKey(reservedRole.name())) {
                logger.warn("role [{}] is reserved to the system. the relevant role definition in the mapping file will be ignored", new Object[]{reservedRole.name()});
            }
            roles.put(reservedRole.name(), reservedRole);
        }
        return ImmutableMap.copyOf(roles);
    }

    private static Permission.Global.Role parseRole(String segment, Path path, ESLogger logger, boolean resolvePermissions, Settings settings) {
        block55: {
            String roleName = null;
            try {
                XContentParser parser = YamlXContent.yamlXContent.createParser(segment);
                XContentParser.Token token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT || (token = parser.nextToken()) != XContentParser.Token.FIELD_NAME) break block55;
                roleName = parser.currentName();
                Validation.Error validationError = Validation.Roles.validateRoleName(roleName);
                if (validationError != null) {
                    logger.error("invalid role definition [{}] in roles file [{}]. invalid role name - {}. skipping role... ", new Object[]{roleName, path.toAbsolutePath(), validationError});
                    return null;
                }
                Permission.Global.Role.Builder permission = Permission.Global.Role.builder(roleName);
                if (!resolvePermissions) {
                    return permission.build();
                }
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        Privilege.Name name;
                        Object names;
                        String namesStr;
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if ("cluster".equals(currentFieldName)) {
                            Privilege.Name name2 = null;
                            if (token == XContentParser.Token.VALUE_STRING) {
                                namesStr = parser.text().trim();
                                if (Strings.hasLength((String)namesStr)) {
                                    names = COMMA_DELIM.split(namesStr);
                                    name2 = new Privilege.Name((String[])names);
                                }
                            } else if (token == XContentParser.Token.START_ARRAY) {
                                HashSet<String> names2 = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    names2.add(parser.text());
                                }
                                if (!names2.isEmpty()) {
                                    name2 = new Privilege.Name(names2);
                                }
                            } else {
                                logger.error("invalid role definition [{}] in roles file [{}]. [cluster] field value can either be a string or a list of strings, but [{}] was found instead. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                return null;
                            }
                            if (name2 == null) continue;
                            try {
                                permission.cluster(Privilege.Cluster.get(name2));
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                logger.error("invalid role definition [{}] in roles file [{}]. could not resolve cluster privileges [{}]. skipping role...", new Object[]{roleName, path.toAbsolutePath(), name2});
                                return null;
                            }
                        }
                        if ("indices".equals(currentFieldName)) {
                            if (token == XContentParser.Token.START_OBJECT) {
                                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    if (token == XContentParser.Token.FIELD_NAME) {
                                        currentFieldName = parser.currentName();
                                        continue;
                                    }
                                    if (!Strings.hasLength((String)currentFieldName)) continue;
                                    String[] indices = COMMA_DELIM.split(currentFieldName);
                                    name = null;
                                    if (token == XContentParser.Token.VALUE_STRING) {
                                        String namesStr2 = parser.text().trim();
                                        if (Strings.hasLength((String)namesStr2)) {
                                            String[] names3 = COMMA_DELIM.split(parser.text());
                                            name = new Privilege.Name(names3);
                                        }
                                    } else if (token == XContentParser.Token.START_ARRAY) {
                                        names = new HashSet();
                                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                            if (token == XContentParser.Token.VALUE_STRING) {
                                                names.add(parser.text());
                                                continue;
                                            }
                                            logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as index privilege. privilege names must be strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                            return null;
                                        }
                                        if (!names.isEmpty()) {
                                            name = new Privilege.Name((Set<String>)names);
                                        }
                                    } else {
                                        if (token == XContentParser.Token.START_OBJECT) {
                                            List<Object> fields = null;
                                            BytesReference query = null;
                                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                                if (token == XContentParser.Token.FIELD_NAME) {
                                                    currentFieldName = parser.currentName();
                                                    continue;
                                                }
                                                if ("fields".equals(currentFieldName)) {
                                                    if (token == XContentParser.Token.START_ARRAY) {
                                                        fields = parser.list();
                                                        continue;
                                                    }
                                                    if (!token.isValue()) continue;
                                                    String field = parser.text();
                                                    if (field.trim().isEmpty()) {
                                                        fields = Collections.emptyList();
                                                        continue;
                                                    }
                                                    fields = Collections.singletonList(field);
                                                    continue;
                                                }
                                                if ("query".equals(currentFieldName)) {
                                                    if (token == XContentParser.Token.START_OBJECT) {
                                                        XContentBuilder builder = JsonXContent.contentBuilder();
                                                        XContentHelper.copyCurrentStructure((XContentGenerator)builder.generator(), (XContentParser)parser);
                                                        query = builder.bytes();
                                                        continue;
                                                    }
                                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                                    query = new BytesArray(parser.text());
                                                    continue;
                                                }
                                                if (!"privileges".equals(currentFieldName)) continue;
                                                if (token == XContentParser.Token.VALUE_STRING) {
                                                    String namesStr3 = parser.text().trim();
                                                    if (!Strings.hasLength((String)namesStr3)) continue;
                                                    String[] names4 = COMMA_DELIM.split(parser.text());
                                                    name = new Privilege.Name(names4);
                                                    continue;
                                                }
                                                if (token != XContentParser.Token.START_ARRAY) continue;
                                                HashSet<String> names5 = new HashSet<String>();
                                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                                    if (token == XContentParser.Token.VALUE_STRING) {
                                                        names5.add(parser.text());
                                                        continue;
                                                    }
                                                    logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as index privilege. privilege names must be strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                                    return null;
                                                }
                                                if (names5.isEmpty()) continue;
                                                name = new Privilege.Name(names5);
                                            }
                                            if (name == null) continue;
                                            if ((query != null || fields != null && !fields.isEmpty()) && !AccessControlShardModule.enabled(settings)) {
                                                logger.error("invalid role definition [{}] in roles file [{}]. document and field level security is not enabled. set [{}] to [true] in the configuration file. skipping role...", new Object[]{roleName, path.toAbsolutePath(), "shield.dls_fls.enabled"});
                                                return null;
                                            }
                                            try {
                                                permission.add((List<String>)fields, query, Privilege.Index.get(name), indices);
                                                continue;
                                            }
                                            catch (IllegalArgumentException e) {
                                                logger.error("invalid role definition [{}] in roles file [{}]. could not resolve indices privileges [{}]. skipping role...", new Object[]{roleName, path.toAbsolutePath(), name});
                                                return null;
                                            }
                                        }
                                        logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as index privileges. privilege lists must either be a comma delimited string or an array of strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                        return null;
                                    }
                                    if (name == null) continue;
                                    try {
                                        permission.add(Privilege.Index.get(name), indices);
                                    }
                                    catch (IllegalArgumentException e) {
                                        logger.error("invalid role definition [{}] in roles file [{}]. could not resolve indices privileges [{}]. skipping role...", new Object[]{roleName, path.toAbsolutePath(), name});
                                        return null;
                                    }
                                }
                                continue;
                            }
                            logger.error("invalid role definition [{}] in roles file [{}]. [indices] field value must be an array of indices-privileges mappings defined as a string in the form <comma-separated list of index name patterns>::<comma-separated list of privileges> , but [{}] was found instead. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                            return null;
                        }
                        if ("run_as".equals(currentFieldName)) {
                            HashSet<String> names6 = new HashSet<String>();
                            if (token == XContentParser.Token.VALUE_STRING) {
                                namesStr = parser.text().trim();
                                if (Strings.hasLength((String)namesStr)) {
                                    String[] namesArr = COMMA_DELIM.split(namesStr);
                                    names6.addAll(Arrays.asList(namesArr));
                                }
                            } else if (token == XContentParser.Token.START_ARRAY) {
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    names6.add(parser.text());
                                }
                            } else {
                                logger.error("invalid role definition [{}] in roles file [{}]. [run_as] field value can either be a string or a list of strings, but [{}] was found instead. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                return null;
                            }
                            if (names6.isEmpty()) continue;
                            name = new Privilege.Name(names6);
                            try {
                                permission.runAs(new Privilege.General(new Privilege.Name(names6), names6.toArray(new String[names6.size()])));
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                logger.error("invalid role definition [{}] in roles file [{}]. could not resolve run_as privileges [{}]. skipping role...", new Object[]{roleName, path.toAbsolutePath(), name});
                                return null;
                            }
                        }
                        logger.warn("unknown field [{}] found in role definition [{}] in roles file [{}]", new Object[]{currentFieldName, roleName, path.toAbsolutePath()});
                    }
                    return permission.build();
                }
                logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", new Object[]{roleName, path.toAbsolutePath()});
            }
            catch (YAMLException | IOException e) {
                if (roleName != null) {
                    logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", e, new Object[]{roleName, path});
                }
                logger.error("invalid role definition in roles file [{}]. skipping role...", e, new Object[]{path});
            }
        }
        return null;
    }

    private static List<String> roleSegments(Path path) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder builder = null;
        for (String line : Files.readAllLines(path, Charsets.UTF_8)) {
            if (SKIP_LINE.matcher(line).matches()) continue;
            if (IN_SEGMENT_LINE.matcher(line).matches()) {
                if (builder == null) continue;
                builder.append(line).append("\n");
                continue;
            }
            if (builder != null) {
                segments.add(builder.toString());
            }
            builder = new StringBuilder(line).append("\n");
        }
        if (builder != null) {
            segments.add(builder.toString());
        }
        return segments;
    }

    private class FileListener
    extends FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileRolesStore.this.file)) {
                try {
                    FileRolesStore.this.permissions = FileRolesStore.parseFile(file, (Set<Permission.Global.Role>)FileRolesStore.this.reservedRoles, FileRolesStore.this.logger, FileRolesStore.this.settings);
                    FileRolesStore.this.logger.info("updated roles (roles file [{}] changed)", new Object[]{file.toAbsolutePath()});
                }
                catch (Throwable t) {
                    FileRolesStore.this.logger.error("could not reload roles file [{}]. Current roles remain unmodified", t, new Object[]{file.toAbsolutePath()});
                    return;
                }
                FileRolesStore.this.listener.onRefresh();
            }
        }
    }
}

