/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.accesscontrol;

import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.shield.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.shield.authz.accesscontrol.RequestContext;

public final class OptOutQueryCache
extends AbstractIndexComponent
implements QueryCache {
    final IndicesQueryCache indicesQueryCache;

    @Inject
    public OptOutQueryCache(Index index, IndexSettingsService indexSettingsService, IndicesQueryCache indicesQueryCache) {
        super(index, indexSettingsService.getSettings());
        this.indicesQueryCache = indicesQueryCache;
    }

    public void close() throws ElasticsearchException {
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", new Object[]{reason});
        this.indicesQueryCache.clearIndex(this.index.getName());
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        String index;
        RequestContext context = RequestContext.current();
        if (context == null) {
            throw new IllegalStateException("opting out of the query cache. current request can't be found");
        }
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)context.getRequest().getFromContext((Object)"_indices_permissions");
        if (indicesAccessControl == null) {
            this.logger.debug("opting out of the query cache. current request doesn't hold indices permissions", new Object[0]);
            return weight;
        }
        if (context.getRequest() instanceof ShardSearchRequest) {
            index = ((ShardSearchRequest)context.getRequest()).index();
        } else if (context.getRequest() instanceof BroadcastShardRequest) {
            index = ((BroadcastShardRequest)context.getRequest()).shardId().getIndex();
        } else {
            return weight;
        }
        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
        if (indexAccessControl != null && indexAccessControl.getFields() != null) {
            this.logger.debug("opting out of the query cache. request for index [{}] has field level security enabled", new Object[]{index});
            return weight;
        }
        this.logger.trace("not opting out of the query cache. request for index [{}] has field level security disabled", new Object[]{index});
        return this.indicesQueryCache.doCache(weight, policy);
    }
}

