/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseListIterator
implements UnfailingIterator,
ReversibleIterator,
LookaheadIterator,
LastPositionFinder {
    List<? extends Item> items;
    int index = 0;
    int start;
    int end;

    public ReverseListIterator(List<? extends Item> items) {
        this.items = items;
        this.index = items.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.index >= 0;
    }

    @Override
    public Item next() {
        if (this.index >= 0) {
            return this.items.get(this.index--);
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.items.size();
    }

    @Override
    public void close() {
    }

    @Override
    public ReverseListIterator getAnother() {
        return new ReverseListIterator(this.items);
    }

    @Override
    public int getProperties() {
        return 2;
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new ListIterator(this.items);
    }
}

