/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.jackson;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamReadConstraintsUtil {
    private final Map<String, String> propertyOverrides;
    private final Logger logger;
    private StreamReadConstraints configuredStreamReadConstraints;

    public static StreamReadConstraintsUtil fromSystemProperties() {
        return new StreamReadConstraintsUtil(System.getProperties());
    }

    StreamReadConstraintsUtil(Properties properties) {
        this(properties, (Logger)null);
    }

    StreamReadConstraintsUtil(Properties properties, Logger logger) {
        this(StreamReadConstraintsUtil.extractProperties(properties), logger);
    }

    private static Map<String, String> extractProperties(Properties properties) {
        return properties.stringPropertyNames().stream().filter(propName -> propName.startsWith("logstash.jackson.stream-read-constraints.")).map(propName -> Map.entry(propName, properties.getProperty((String)propName))).filter(entry -> entry.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private StreamReadConstraintsUtil(Map<String, String> propertyOverrides, Logger logger) {
        this.propertyOverrides = Map.copyOf(propertyOverrides);
        this.logger = Objects.requireNonNullElseGet(logger, () -> LogManager.getLogger(StreamReadConstraintsUtil.class));
    }

    StreamReadConstraints get() {
        if (this.configuredStreamReadConstraints == null) {
            StreamReadConstraints.Builder builder = StreamReadConstraints.defaults().rebuild();
            this.eachOverride((override, specifiedValue) -> override.apply(builder, (Integer)specifiedValue));
            this.configuredStreamReadConstraints = builder.build();
        }
        return this.configuredStreamReadConstraints;
    }

    public void applyAsGlobalDefault() {
        StreamReadConstraints.overrideDefaultStreamReadConstraints((StreamReadConstraints)this.get());
    }

    public void validateIsGlobalDefault() {
        this.validate(StreamReadConstraints.defaults());
    }

    public void validate(StreamReadConstraints streamReadConstraints) {
        ArrayList fatalIssues = new ArrayList();
        this.eachOverride((override, specifiedValue) -> {
            int effectiveValue = override.observe(streamReadConstraints);
            int expectedValue = override.resolve((Integer)specifiedValue);
            if (!Objects.equals(effectiveValue, expectedValue)) {
                fatalIssues.add(String.format("`%s` (expected: `%s`, actual: `%s`)", override.propertyName, expectedValue, effectiveValue));
            } else {
                String reason = Objects.nonNull(specifiedValue) ? "system properties" : "logstash default";
                this.logger.info("Jackson default value override `{}` configured to `{}` ({})", (Object)override.propertyName, (Object)effectiveValue, (Object)reason);
            }
        });
        for (String unsupportedProperty : this.getUnsupportedProperties()) {
            this.logger.warn("Jackson default value override `{}` is unknown and has been ignored", (Object)unsupportedProperty);
        }
        if (!fatalIssues.isEmpty()) {
            throw new IllegalStateException(String.format("Jackson default values not applied: %s", String.join((CharSequence)",", fatalIssues)));
        }
    }

    void eachOverride(BiConsumer<Override, Integer> overrideIntegerBiConsumer) {
        for (Override override : Override.values()) {
            String propValue = this.propertyOverrides.get(override.propertyName);
            try {
                Integer explicitValue = Optional.ofNullable(propValue).map(Integer::parseInt).orElse(null);
                overrideIntegerBiConsumer.accept(override, explicitValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("System property `%s` must be positive integer value. Received: `%s`", override.propertyName, propValue), e);
            }
        }
    }

    Set<String> getUnsupportedProperties() {
        Set supportedProps = Arrays.stream(Override.values()).map(p -> p.propertyName).collect(Collectors.toSet());
        Set<String> providedProps = this.propertyOverrides.keySet();
        return Sets.difference(providedProps, supportedProps);
    }

    static enum Override {
        MAX_STRING_LENGTH(200000000, StreamReadConstraints.Builder::maxStringLength, StreamReadConstraints::getMaxStringLength),
        MAX_NUMBER_LENGTH(10000, StreamReadConstraints.Builder::maxNumberLength, StreamReadConstraints::getMaxNumberLength),
        MAX_NESTING_DEPTH(1000, StreamReadConstraints.Builder::maxNestingDepth, StreamReadConstraints::getMaxNestingDepth);

        static final String PROP_PREFIX = "logstash.jackson.stream-read-constraints.";
        final String propertyName = "logstash.jackson.stream-read-constraints." + this.name().toLowerCase().replace('_', '-');
        final int defaultValue;
        private final IntValueApplicator applicator;
        private final IntValueObserver observer;

        private Override(int defaultValue, IntValueApplicator applicator, IntValueObserver observer) {
            this.defaultValue = defaultValue;
            this.applicator = applicator;
            this.observer = observer;
        }

        int resolve(Integer specifiedValue) {
            return Objects.requireNonNullElse(specifiedValue, this.defaultValue);
        }

        void apply(StreamReadConstraints.Builder constraintsBuilder, @Nullable Integer specifiedValue) {
            this.applicator.applyIntValue(constraintsBuilder, this.resolve(specifiedValue));
        }

        int observe(StreamReadConstraints constraints) {
            return this.observer.observeIntValue(constraints);
        }

        @FunctionalInterface
        static interface IntValueApplicator {
            public StreamReadConstraints.Builder applyIntValue(StreamReadConstraints.Builder var1, int var2);
        }

        @FunctionalInterface
        static interface IntValueObserver {
            public int observeIntValue(StreamReadConstraints var1);
        }
    }
}

