/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp.mib;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logstash.snmp.DefaultOidFieldMapper;
import org.logstash.snmp.OidFieldMapper;
import org.logstash.snmp.mib.FileUtils;
import org.logstash.snmp.mib.MibReader;
import org.logstash.snmp.mib.OidData;
import org.logstash.snmp.mib.OidTrie;
import org.logstash.snmp.mib.RubySnmpMibReader;
import org.logstash.snmp.mib.SmilibPythonMibReader;
import org.snmp4j.smi.OID;

public class MibManager {
    private final OidTrie oidTrie;
    private final OidFieldMapper fieldMapper;
    private final Map<String, MibReader> mibFileReaders;

    public MibManager() {
        this(new DefaultOidFieldMapper(0, 0));
    }

    public MibManager(OidFieldMapper fieldMapper) {
        this(new OidTrie(), fieldMapper, Map.of("dic", new SmilibPythonMibReader(), "yaml", new RubySnmpMibReader()));
    }

    MibManager(OidTrie oidTrie, OidFieldMapper fieldMapper, Map<String, MibReader> mibFileReaders) {
        this.oidTrie = oidTrie;
        this.fieldMapper = fieldMapper;
        this.mibFileReaders = mibFileReaders;
    }

    public void add(String path) throws IOException {
        try (Stream<Path> allFilesMib = Files.walk(Path.of(path, new String[0]), new FileVisitOption[0]);){
            Map filesPerExtension = allFilesMib.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.groupingBy(FileUtils::getFileExtension, HashMap::new, Collectors.toCollection(TreeSet::new)));
            filesPerExtension.forEach((extension, files) -> {
                if (this.mibFileReaders.containsKey(extension)) {
                    this.mibFileReaders.get(extension).read((Collection<Path>)files, this.oidTrie::insert);
                }
            });
        }
        OID isoOid = new OID("1");
        if (this.oidTrie.find(isoOid).isEmpty()) {
            this.oidTrie.insert(isoOid, new OidData("node", "iso", "logstash"));
        }
    }

    public String map(OID oid) {
        ArrayList resolvedIdentifiers = new ArrayList(oid.getValue().length);
        this.oidTrie.find(oid, node -> resolvedIdentifiers.add(new OidFieldMapper.ResolvedIdentifier(node.getIdentifier(), node.getData())));
        return this.fieldMapper.map(oid, (OidFieldMapper.ResolvedIdentifier[])resolvedIdentifiers.toArray(OidFieldMapper.ResolvedIdentifier[]::new));
    }

    Map<String, MibReader> getMibFileReaders() {
        return Collections.unmodifiableMap(this.mibFileReaders);
    }

    public OidFieldMapper getFieldMapper() {
        return this.fieldMapper;
    }
}

