/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetXACallInfo;

class NetXAConnectionReply
extends NetResultSetReply {
    NetXAConnectionReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    @Override
    public void readLocalXAStart(ConnectionCallbackInterface connection) throws DisconnectException {
    }

    @Override
    public void readLocalXACommit(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connection);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = this.netAgent_.netConnection_.xares_.callInfoArray_[this.netAgent_.netConnection_.currXACallInfoOffset_];
        connection.completeLocalCommit();
    }

    @Override
    public void readLocalXARollback(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connection);
        this.endOfSameIdChainData();
        connection.completeLocalRollback();
    }

    @Override
    void readXaStartUnitOfWork(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        boolean keep = callInfo.xaFlags_ == 0x200000 || callInfo.xaFlags_ == 0x8000000;
        conn.xares_.setKeepCurrentIsolationLevel(keep);
        this.endOfSameIdChainData();
    }

    @Override
    int readXaEndUnitOfWork(NetConnection conn) throws DisconnectException {
        conn.xares_.setKeepCurrentIsolationLevel(false);
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        int xaFlags = callInfo.xaFlags_;
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        if (xaFlags == 0x20000000) {
            return 100;
        }
        return 0;
    }

    @Override
    int readXaPrepare(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        int synctype = this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        return synctype;
    }

    @Override
    void readXaCommit(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        conn.completeLocalCommit();
    }

    @Override
    int readXaRollback(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
        NetXACallInfo callInfo = conn.xares_.callInfoArray_[conn.currXACallInfoOffset_];
        conn.completeLocalRollback();
        return 0;
    }

    @Override
    void readXaRecover(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
    }

    @Override
    void readXaForget(NetConnection conn) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(conn);
        this.endOfSameIdChainData();
    }

    @Override
    int parseSYNCCRD(ConnectionCallbackInterface connection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        int xaretval = 0;
        byte synctype = 0;
        NetConnection conn = this.netAgent_.netConnection_;
        this.parseLengthAndMatchCodePoint(4680);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 6404) {
                foundInPass = true;
                conn.xares_.callInfoArray_[conn.currXACallInfoOffset_].xaRetVal_ = xaretval = this.parseXARETVAL();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4487) {
                foundInPass = true;
                synctype = this.parseSYNCTYPE();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 6405) {
                foundInPass = true;
                conn.setIndoubtTransactions(this.parseIndoubtList());
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        return xaretval;
    }

    @Override
    int parseXARETVAL() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6404);
        return this.readInt();
    }

    @Override
    byte parseSYNCTYPE() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4487);
        return this.readByte();
    }

    @Override
    int parseSYNCCTLreply(ConnectionCallbackInterface connection) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        if (peekCP != 4680) {
            this.parseSYNCCTLError(peekCP);
            return -1;
        }
        int retval = this.parseSYNCCRD(connection);
        peekCP = this.peekCodePoint();
        while (peekCP == 9236) {
            String s = this.parseSQLSTT();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
        return retval;
    }

    private String parseSQLSTT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9236);
        return this.parseSQLSTTGRPNOCMorNOCS();
    }

    private String parseSQLSTTGRPNOCMorNOCS() throws DisconnectException {
        int mixedNullInd = this.readUnsignedByte();
        int singleNullInd = 0;
        String sqlsttString = null;
        int stringLength = 0;
        if (mixedNullInd == 255) {
            singleNullInd = this.readUnsignedByte();
            if (singleNullInd == 255) {
                this.doDtamchrmSemantics();
            }
            stringLength = this.readInt();
            sqlsttString = this.readString(stringLength, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        } else {
            stringLength = this.readInt();
            sqlsttString = this.readString(stringLength, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            singleNullInd = this.readUnsignedByte();
        }
        return sqlsttString;
    }

    @Override
    int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    @Override
    Xid parseXID() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6145);
        int formatId = this.readInt();
        int gtridLen = this.readInt();
        int bqualLen = this.readInt();
        byte[] gtrid = this.readBytes(gtridLen);
        byte[] bqual = this.readBytes(bqualLen);
        return new ClientXid(formatId, gtrid, bqual);
    }

    @Override
    List<Xid> parseIndoubtList() throws DisconnectException {
        this.peekCodePoint();
        this.parseLengthAndMatchCodePoint(6405);
        int peekCP = this.peekCodePoint();
        if (peekCP == 6406) {
            this.parseXIDCNT();
            peekCP = this.peekCodePoint();
        }
        ArrayList<Xid> indoubtTransactions = new ArrayList<Xid>();
        while (peekCP == 6145) {
            Xid xid = this.parseXID();
            indoubtTransactions.add(xid);
            peekCP = this.peekCodePoint();
        }
        return indoubtTransactions;
    }
}

