/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.ClientXAConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.CachingLogicalConnection;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientDatabaseMetaData;
import org.apache.derby.client.am.ClientJDBCObjectFactory;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientParameterMetaData;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.LogicalCallableStatement;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.LogicalPreparedStatement;
import org.apache.derby.client.am.MaterialStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetDatabaseMetaData;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class ClientJDBCObjectFactoryImpl
implements ClientJDBCObjectFactory {
    private static final MessageUtil msgutil_ = SqlException.getMessageUtil();

    @Override
    public ClientPooledConnection newClientPooledConnection(BasicClientDataSource ds, LogWriter logWriter, String user, String password) throws SQLException {
        return new ClientPooledConnection(ds, logWriter, user, password);
    }

    @Override
    public ClientXAConnection newClientXAConnection(BasicClientDataSource ds, LogWriter logWriter, String user, String password) throws SQLException {
        return new ClientXAConnection(ds, logWriter, user, password);
    }

    @Override
    public ClientCallableStatement newCallableStatement(Agent agent, ClientConnection connection, String sql, int type, int concurrency, int holdability, ClientPooledConnection cpc) throws SqlException {
        return new ClientCallableStatement(agent, connection, sql, type, concurrency, holdability, cpc);
    }

    @Override
    public LogicalConnection newLogicalConnection(ClientConnection physicalConnection, ClientPooledConnection pooledConnection) throws SqlException {
        return new LogicalConnection(physicalConnection, pooledConnection);
    }

    @Override
    public LogicalConnection newCachingLogicalConnection(ClientConnection physicalConnection, ClientPooledConnection pooledConnection, JDBCStatementCache stmtCache) throws SqlException {
        return new CachingLogicalConnection(physicalConnection, pooledConnection, stmtCache);
    }

    @Override
    public ClientPreparedStatement newPreparedStatement(Agent agent, ClientConnection connection, String sql, Section section, ClientPooledConnection cpc) throws SqlException {
        return new ClientPreparedStatement(agent, connection, sql, section, cpc);
    }

    @Override
    public ClientPreparedStatement newPreparedStatement(Agent agent, ClientConnection connection, String sql, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes, ClientPooledConnection cpc) throws SqlException {
        return new ClientPreparedStatement(agent, connection, sql, type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes, cpc);
    }

    @Override
    public LogicalPreparedStatement newLogicalPreparedStatement(PreparedStatement ps, StatementKey stmtKey, StatementCacheInteractor cacheInteractor) {
        return new LogicalPreparedStatement(ps, stmtKey, cacheInteractor);
    }

    @Override
    public LogicalCallableStatement newLogicalCallableStatement(CallableStatement cs, StatementKey stmtKey, StatementCacheInteractor cacheInteractor) {
        return new LogicalCallableStatement(cs, stmtKey, cacheInteractor);
    }

    @Override
    public ClientConnection newNetConnection(LogWriter logWriter, int driverManagerLoginTimeout, String serverName, int portNumber, String databaseName, Properties properties) throws SqlException {
        return new NetConnection(logWriter, driverManagerLoginTimeout, serverName, portNumber, databaseName, properties);
    }

    @Override
    public ClientConnection newNetConnection(LogWriter logWriter, String user, String password, BasicClientDataSource dataSource, int rmId, boolean isXAConn) throws SqlException {
        return new NetConnection(logWriter, user, password, dataSource, rmId, isXAConn);
    }

    @Override
    public ClientConnection newNetConnection(LogWriter logWriter, String user, String password, BasicClientDataSource dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        return new NetConnection(logWriter, user, password, dataSource, rmId, isXAConn, cpc);
    }

    @Override
    public ClientResultSet newNetResultSet(Agent netAgent, MaterialStatement netStatement, Cursor cursor, int qryprctyp, int sqlcsrhld, int qryattscr, int qryattsns, int qryattset, long qryinsid, int actualResultSetType, int actualResultSetConcurrency, int actualResultSetHoldability) throws SqlException {
        return new NetResultSet((NetAgent)netAgent, (NetStatement)netStatement, cursor, qryprctyp, sqlcsrhld, qryattscr, qryattsns, qryattset, qryinsid, actualResultSetType, actualResultSetConcurrency, actualResultSetHoldability);
    }

    @Override
    public ClientDatabaseMetaData newNetDatabaseMetaData(Agent netAgent, ClientConnection netConnection) {
        return new NetDatabaseMetaData((NetAgent)netAgent, (NetConnection)netConnection);
    }

    @Override
    public ClientStatement newStatement(Agent agent, ClientConnection connection, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        return new ClientStatement(agent, connection, type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    @Override
    public ColumnMetaData newColumnMetaData(LogWriter logWriter) {
        return new ColumnMetaData(logWriter);
    }

    @Override
    public ColumnMetaData newColumnMetaData(LogWriter logWriter, int upperBound) {
        return new ColumnMetaData(logWriter, upperBound);
    }

    @Override
    public ClientParameterMetaData newParameterMetaData(ColumnMetaData columnMetaData) {
        return new ClientParameterMetaData(columnMetaData);
    }

    @Override
    public BatchUpdateException newBatchUpdateException(LogWriter logWriter, ClientMessageId msgid, Object[] args, long[] updateCounts, SqlException cause) {
        BatchUpdateException bue = this.newBatchUpdateException(msgutil_.getCompleteMessage(msgid.msgid, args), ExceptionUtil.getSQLStateFromIdentifier((String)msgid.msgid), ExceptionUtil.getSeverityFromIdentifier((String)msgid.msgid), updateCounts, cause);
        if (logWriter != null) {
            logWriter.traceDiagnosable(bue);
        }
        if (cause != null) {
            bue.setNextException(cause.getSQLException());
        }
        return bue;
    }

    protected BatchUpdateException newBatchUpdateException(String message, String sqlState, int errorCode, long[] updateCounts, SqlException cause) {
        BatchUpdateException bue = new BatchUpdateException(message, sqlState, errorCode, Utils.squashLongs(updateCounts));
        if (cause != null) {
            bue.initCause(cause);
        }
        return bue;
    }
}

