/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ValueNodeList
extends QueryTreeNodeVector<ValueNode> {
    ValueNodeList(ContextManager cm) {
        super(ValueNode.class, cm);
    }

    void addValueNode(ValueNode valueNode) throws StandardException {
        this.addElement(valueNode);
    }

    void bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vn = (ValueNode)this.elementAt(index);
            vn = vn.bindExpression(fromList, subqueryList, aggregates);
            this.setElementAt(vn, index);
        }
    }

    void genSQLJavaSQLTrees() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (!valueNode.getTypeId().userType()) continue;
            this.setElementAt(valueNode.genSQLJavaSQLTree(), index);
        }
    }

    DataTypeDescriptor getDominantTypeServices() throws StandardException {
        DataTypeDescriptor dominantDTS = null;
        int firstCollationDerivation = -1;
        int firstCollationType = -1;
        boolean foundCollationMisMatch = false;
        for (int index = 0; index < this.size(); ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (valueNode.requiresTypeFromContext() && valueNode.getTypeServices() == null) continue;
            DataTypeDescriptor valueNodeDTS = valueNode.getTypeServices();
            if (valueNodeDTS.getTypeId().isStringTypeId()) {
                if (firstCollationDerivation == -1) {
                    firstCollationDerivation = valueNodeDTS.getCollationDerivation();
                    firstCollationType = valueNodeDTS.getCollationType();
                } else if (!foundCollationMisMatch) {
                    if (firstCollationDerivation != valueNodeDTS.getCollationDerivation()) {
                        foundCollationMisMatch = true;
                    } else if (firstCollationType != valueNodeDTS.getCollationType()) {
                        foundCollationMisMatch = true;
                    }
                }
            }
            dominantDTS = dominantDTS == null ? valueNodeDTS : dominantDTS.getDominantType(valueNodeDTS, this.getClassFactory());
        }
        if (firstCollationDerivation != -1 && foundCollationMisMatch) {
            dominantDTS = dominantDTS.getCollatedType(dominantDTS.getCollationType(), 0);
        }
        return dominantDTS;
    }

    DataTypeDescriptor getTypeServices() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            DataTypeDescriptor valueNodeDTS = valueNode.getTypeServices();
            if (valueNodeDTS == null) continue;
            return valueNodeDTS;
        }
        return null;
    }

    boolean allSamePrecendence(int precedence) {
        boolean allSame = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            DataTypeDescriptor valueNodeDTS = valueNode.getTypeServices();
            if (valueNodeDTS == null) {
                return false;
            }
            if (precedence == valueNodeDTS.getTypeId().typePrecedence()) continue;
            return false;
        }
        return allSame;
    }

    void compatible(ValueNode leftOperand) throws StandardException {
        TypeId leftType = leftOperand.getTypeId();
        TypeCompiler leftTC = leftOperand.getTypeCompiler();
        for (ValueNode valueNode : this) {
            if (valueNode.requiresTypeFromContext() || leftTC.compatible(valueNode.getTypeId())) continue;
            throw StandardException.newException((String)"42815.S.171", (Object[])new Object[]{leftType.getSQLTypeName(), valueNode.getTypeId().getSQLTypeName()});
        }
    }

    void comparable(ValueNode leftOperand) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (leftOperand.getTypeServices().comparable(valueNode.getTypeServices(), false, this.getClassFactory())) continue;
            throw StandardException.newException((String)"42818", (Object[])new Object[]{leftOperand.getTypeServices().getSQLTypeNameWithCollation(), valueNode.getTypeServices().getSQLTypeNameWithCollation()});
        }
    }

    boolean isNullable() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (!((ValueNode)this.elementAt(index)).getTypeServices().isNullable()) continue;
            return true;
        }
        return false;
    }

    boolean containsParameterNode() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (!((ValueNode)this.elementAt(index)).requiresTypeFromContext()) continue;
            return true;
        }
        return false;
    }

    boolean containsAllParameterNodes() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((ValueNode)this.elementAt(index)).requiresTypeFromContext()) continue;
            return false;
        }
        return true;
    }

    boolean containsAllConstantNodes() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (this.elementAt(index) instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    boolean containsOnlyConstantAndParamNodes() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vNode = (ValueNode)this.elementAt(index);
            if (vNode.requiresTypeFromContext() || vNode instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    void sortInAscendingOrder(DataValueDescriptor judgeODV) throws StandardException {
        int size = this.size();
        SanityManager.ASSERT((size > 0 ? 1 : 0) != 0, (String)"size() expected to be non-zero");
        boolean continueSort = true;
        while (continueSort) {
            continueSort = false;
            for (int index = 1; index < size; ++index) {
                ConstantNode currCN = (ConstantNode)this.elementAt(index);
                DataValueDescriptor currODV = currCN.getValue();
                ConstantNode prevCN = (ConstantNode)this.elementAt(index - 1);
                DataValueDescriptor prevODV = prevCN.getValue();
                if ((judgeODV != null || prevODV.compare(currODV) <= 0) && (judgeODV == null || !judgeODV.greaterThan(prevODV, currODV).equals(true))) continue;
                this.setElementAt(currCN, index - 1);
                this.setElementAt(prevCN, index);
                continueSort = true;
            }
        }
    }

    void eliminateNots(boolean underNotNode) throws StandardException {
        for (int i = 0; i < this.size(); ++i) {
            this.setElementAt(((ValueNode)this.elementAt(i)).eliminateNots(underNotNode), i);
        }
    }

    void setParameterDescriptor(DataTypeDescriptor descriptor) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (!valueNode.requiresTypeFromContext()) continue;
            valueNode.setType(descriptor);
        }
    }

    void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vn = ((ValueNode)this.elementAt(index)).preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
            this.setElementAt(vn, index);
        }
    }

    ValueNodeList remapColumnReferencesToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            this.setElementAt(((ValueNode)this.elementAt(index)).remapColumnReferencesToExpressions(), index);
        }
        return this;
    }

    boolean isEquivalent(ValueNodeList other) throws StandardException {
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ValueNode vn2;
            ValueNode vn1 = (ValueNode)this.elementAt(i);
            if (vn1.isEquivalent(vn2 = (ValueNode)other.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    boolean isConstantExpression() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            boolean retcode = ((ValueNode)this.elementAt(index)).isConstantExpression();
            if (retcode) continue;
            return retcode;
        }
        return true;
    }

    boolean constantExpression(PredicateList whereClause) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            boolean retcode = ((ValueNode)this.elementAt(index)).constantExpression(whereClause);
            if (retcode) continue;
            return retcode;
        }
        return true;
    }

    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            pushable = ((ValueNode)this.elementAt(index)).categorize(referencedTabs, simplePredsOnly) && pushable;
        }
        return pushable;
    }

    protected int getOrderableVariantType() throws StandardException {
        int listType = 3;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            int curType = ((ValueNode)this.elementAt(index)).getOrderableVariantType();
            listType = Math.min(listType, curType);
        }
        return listType;
    }
}

