/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class GroupByColumn
extends OrderedColumn {
    private ValueNode columnExpression;

    GroupByColumn(ValueNode colRef, ContextManager cm) {
        super(cm);
        this.columnExpression = colRef;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.columnExpression != null) {
            this.printLabel(depth, "columnExpression: ");
            this.columnExpression.treePrint(depth + 1);
        }
    }

    String getColumnName() {
        return this.columnExpression.getColumnName();
    }

    void bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        int previousReliability = this.orReliability(16384);
        this.columnExpression = this.columnExpression.bindExpression(fromList, subqueryList, aggregates);
        this.getCompilerContext().setReliability(previousReliability);
        if (this.columnExpression.isParameterNode()) {
            throw StandardException.newException((String)"42Y36", (Object[])new Object[]{this.columnExpression});
        }
        TypeId ctid = this.columnExpression.getTypeId();
        if (!ctid.orderable(this.getClassFactory())) {
            throw StandardException.newException((String)"X0X67.S", (Object[])new Object[]{ctid.getSQLTypeName()});
        }
    }

    ValueNode getColumnExpression() {
        return this.columnExpression;
    }

    void setColumnExpression(ValueNode cexpr) {
        this.columnExpression = cexpr;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.columnExpression != null) {
            this.columnExpression = (ValueNode)this.columnExpression.accept(v);
        }
    }
}

