/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access.xa;

import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.store.access.GlobalXact;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public class XAXactId
extends GlobalXact
implements Xid {
    private static final char COLON = ':';

    private void copy_init_xid(int format_id, byte[] global_id, byte[] branch_id) {
        this.format_id = format_id;
        this.global_id = (byte[])global_id.clone();
        this.branch_id = (byte[])branch_id.clone();
    }

    public XAXactId(int format_id, byte[] global_id, byte[] branch_id) {
        this.copy_init_xid(format_id, global_id, branch_id);
    }

    public XAXactId(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-4);
        }
        this.copy_init_xid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public String toHexString() {
        int maxLength = 20 + (this.global_id.length + this.branch_id.length) * 2;
        StringBuffer hexdump = new StringBuffer(maxLength);
        hexdump.append(':').append(Integer.toString(this.global_id.length)).append(':').append(Integer.toString(this.branch_id.length)).append(':').append(Integer.toString(this.format_id, 16)).append(':').append(StringUtil.toHexString(this.global_id, 0, this.global_id.length)).append(':').append(StringUtil.toHexString(this.branch_id, 0, this.branch_id.length)).append(':');
        return hexdump.toString();
    }

    public XAXactId(String xactIdString) {
        int start = 1;
        int end = xactIdString.indexOf(58, start);
        SanityManager.ASSERT((end != -1 ? 1 : 0) != 0, (String)"illegal string format");
        String xx = xactIdString.substring(start, end);
        int N = Integer.parseInt(xx);
        SanityManager.ASSERT((N > 0 && N <= 64 ? 1 : 0) != 0, (String)"illegal gtrid size");
        start = end + 1;
        end = xactIdString.indexOf(58, start);
        SanityManager.ASSERT((end != -1 ? 1 : 0) != 0, (String)"illegal string format");
        String yy = xactIdString.substring(start, end);
        int M = Integer.parseInt(yy);
        SanityManager.ASSERT((M > 0 && N <= 64 ? 1 : 0) != 0, (String)"illegal bqual size");
        start = end + 1;
        end = xactIdString.indexOf(58, start);
        SanityManager.ASSERT((end != -1 ? 1 : 0) != 0, (String)"illegal string format");
        String f = xactIdString.substring(start, end);
        this.format_id = Integer.parseInt(f, 16);
        start = end + 1;
        end = xactIdString.indexOf(58, start);
        SanityManager.ASSERT((end != -1 ? 1 : 0) != 0, (String)"illegal string format");
        this.global_id = StringUtil.fromHexString(xactIdString, start, end - start);
        SanityManager.ASSERT((this.global_id.length == N ? 1 : 0) != 0, (String)"inconsistent global_id length");
        start = end + 1;
        end = xactIdString.indexOf(58, start);
        SanityManager.ASSERT((end != -1 ? 1 : 0) != 0, (String)"illegal string format");
        this.branch_id = StringUtil.fromHexString(xactIdString, start, end - start);
        SanityManager.ASSERT((this.branch_id.length == M ? 1 : 0) != 0, (String)("inconsistent branch_id length, expect " + M + " got " + this.branch_id.length));
    }

    @Override
    public int getFormatId() {
        return this.format_id;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.global_id.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branch_id.clone();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            if (other instanceof GlobalXact) {
                return super.equals(other);
            }
            Xid other_xid = (Xid)other;
            return Arrays.equals(other_xid.getGlobalTransactionId(), this.global_id) && Arrays.equals(other_xid.getBranchQualifier(), this.branch_id) && other_xid.getFormatId() == this.format_id;
        }
        catch (ClassCastException cce) {
            SanityManager.THROWASSERT((String)("comparing XAXactId with " + other.getClass().getName()), (Throwable)cce);
            return false;
        }
    }
}

