/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.StringHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class ClientDataHttpHeaders {
    public static final String PRODUCT_HEADER_NAME = "x-client-SKU";
    public static final String PRODUCT_HEADER_VALUE = "java";
    public static final String PRODUCT_VERSION_HEADER_NAME = "x-client-VER";
    public static final String PRODUCT_VERSION_HEADER_VALUE = ClientDataHttpHeaders.getProductVersion();
    public static final String CPU_HEADER_NAME = "x-client-CPU";
    public static final String CPU_HEADER_VALUE = System.getProperty("os.arch");
    public static final String OS_HEADER_NAME = "x-client-OS";
    public static final String OS_HEADER_VALUE = System.getProperty("os.name");
    public static final String CORRELATION_ID_HEADER_NAME = "client-request-id";
    public final String correlationIdHeaderValue;
    public static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME = "return-client-request-id";
    public static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE = "true";
    private final String headerValues;
    private final Map<String, String> headerMap = new HashMap<String, String>();

    private static String generateCorrelationId() {
        return UUID.randomUUID().toString();
    }

    ClientDataHttpHeaders(String correlationId) {
        this.correlationIdHeaderValue = !StringHelper.isBlank(correlationId) ? correlationId : ClientDataHttpHeaders.generateCorrelationId();
        this.headerValues = this.initHeaderMap();
    }

    private String initHeaderMap() {
        StringBuilder sb = new StringBuilder();
        this.headerMap.put(PRODUCT_HEADER_NAME, PRODUCT_HEADER_VALUE);
        sb.append(PRODUCT_HEADER_NAME);
        sb.append("=");
        sb.append(PRODUCT_HEADER_VALUE);
        sb.append(";");
        this.headerMap.put(PRODUCT_VERSION_HEADER_NAME, PRODUCT_VERSION_HEADER_VALUE);
        sb.append(PRODUCT_VERSION_HEADER_NAME);
        sb.append("=");
        sb.append(PRODUCT_VERSION_HEADER_VALUE);
        sb.append(";");
        this.headerMap.put(OS_HEADER_NAME, OS_HEADER_VALUE);
        sb.append(OS_HEADER_NAME);
        sb.append("=");
        sb.append(OS_HEADER_VALUE);
        sb.append(";");
        this.headerMap.put(CPU_HEADER_NAME, CPU_HEADER_VALUE);
        sb.append(CPU_HEADER_NAME);
        sb.append("=");
        sb.append(CPU_HEADER_VALUE);
        sb.append(";");
        this.headerMap.put(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME, REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE);
        sb.append(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME);
        sb.append("=");
        sb.append(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE);
        sb.append(";");
        this.headerMap.put(CORRELATION_ID_HEADER_NAME, this.correlationIdHeaderValue);
        sb.append(CORRELATION_ID_HEADER_NAME);
        sb.append("=");
        sb.append(this.correlationIdHeaderValue);
        sb.append(";");
        return sb.toString();
    }

    Map<String, String> getReadonlyHeaderMap() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    String getHeaderCorrelationIdValue() {
        return this.correlationIdHeaderValue;
    }

    public String toString() {
        return this.headerValues;
    }

    private static String getProductVersion() {
        if (ClientDataHttpHeaders.class.getPackage().getImplementationVersion() == null) {
            return "1.0";
        }
        return ClientDataHttpHeaders.class.getPackage().getImplementationVersion();
    }
}

