/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.PolyglotModelManager;

@Singleton
@Named
public class TeslaModelTranslator {
    protected Logger log = LoggerFactory.getLogger(TeslaModelTranslator.class);
    @Inject
    private PolyglotModelManager manager;

    public void translate(File input, File output) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        HashMap<String, File> inputOptions = new HashMap<String, File>();
        inputOptions.put("org.apache.maven.model.building.source", input);
        HashMap<String, File> outputOptions = new HashMap<String, File>();
        outputOptions.put("org.apache.maven.model.building.source", output);
        this.translate(input, inputOptions, output, outputOptions);
    }

    public void translate(File input, Map<String, ?> inputOptions, File output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        ModelReader reader = this.manager.getReaderFor(inputOptions);
        Model model = reader.read(input, inputOptions);
        ModelWriter writer = this.manager.getWriterFor(outputOptions);
        writer.write(output, outputOptions, model);
    }

    public void translate(URL input, URL output) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        HashMap<String, URL> inputOptions = new HashMap<String, URL>();
        inputOptions.put("org.apache.maven.model.building.source", input);
        HashMap<String, URL> outputOptions = new HashMap<String, URL>();
        outputOptions.put("org.apache.maven.model.building.source", output);
        this.translate(input, inputOptions, output, outputOptions);
    }

    public void translate(URL input, Map<String, ?> inputOptions, URL output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        OutputStream out;
        assert (input != null);
        assert (output != null);
        if (output.getProtocol().equals("file")) {
            File file = new File(output.getPath());
            out = new BufferedOutputStream(new FileOutputStream(file));
        } else {
            out = output.openConnection().getOutputStream();
        }
        try {
            this.translate(input.openStream(), inputOptions, out, outputOptions);
        }
        finally {
            out.flush();
        }
    }

    public void translate(InputStream input, Map<String, ?> inputOptions, OutputStream output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        ModelReader reader = this.manager.getReaderFor(inputOptions);
        Model model = reader.read(input, inputOptions);
        ModelWriter writer = this.manager.getWriterFor(outputOptions);
        writer.write(output, outputOptions, model);
    }

    public void translate(Reader input, Map<String, ?> inputOptions, Writer output, Map<String, ?> outputOptions) throws IOException, ModelParseException {
        assert (input != null);
        assert (output != null);
        ModelReader reader = this.manager.getReaderFor(inputOptions);
        Model model = reader.read(input, inputOptions);
        ModelWriter writer = this.manager.getWriterFor(outputOptions);
        writer.write(output, outputOptions, model);
    }
}

