/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;

public class ClientCallableStatement
extends ClientPreparedStatement
implements PreparedStatement,
CallableStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialCallableStatement_ = null;
    private int wasNull_ = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;

    private void initCallableStatement() {
        this.materialCallableStatement_ = null;
        this.wasNull_ = 0;
    }

    @Override
    public void reset(boolean fullReset) throws SqlException {
        if (fullReset) {
            this.connection_.resetPrepareCall(this);
        } else {
            super.reset(fullReset);
        }
        this.wasNull_ = 0;
    }

    public ClientCallableStatement(Agent agent, ClientConnection connection, String sql, int type, int concurrency, int holdability, ClientPooledConnection cpc) throws SqlException {
        super(agent, connection, sql, type, concurrency, holdability, 2, null, null, cpc);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, ClientConnection connection, String sql, int type, int concurrency, int holdability) throws SqlException {
        super.resetPreparedStatement(agent, connection, sql, type, concurrency, holdability, 2, null, null);
        this.initCallableStatement();
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters", new Object[0]);
            }
            super.clearParameters();
            this.outputRegistered_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int parameterIndex, int jdbcType) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "registerOutParameter", parameterIndex, jdbcType);
                }
                this.registerOutParameterX(parameterIndex, jdbcType);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void registerOutParameterX(int parameterIndex, int jdbcType) throws SqlException {
        super.checkForClosedStatement();
        int scale = 0;
        this.registerOutParameterX(parameterIndex, jdbcType, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int parameterIndex, int jdbcType, int scale) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "registerOutParameter", parameterIndex, jdbcType, scale);
                }
                super.checkForClosedStatement();
                this.registerOutParameterX(parameterIndex, jdbcType, scale);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void registerOutParameterX(int parameterIndex, int jdbcType, int scale) throws SqlException {
        super.checkForValidParameterIndex(parameterIndex);
        this.agent_.checkForSupportedDataType(jdbcType);
        this.checkForValidScale(scale);
        this.outputRegistered_ = true;
        this.parameterRegistered_[parameterIndex - 1] = true;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", parameterIndex, jdbcType, typeName);
        }
        this.registerOutParameter(parameterIndex, jdbcType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull", new Object[0]);
            }
            boolean result = this.wasNullX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", result);
            }
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean wasNullX() throws SqlException {
        super.checkForClosedStatement();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"), new Object[0]);
        }
        return this.wasNull_ == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                boolean result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBoolean", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                boolean bl = result = this.wasNullX() ? false : this.singletonRowData_.getBoolean(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBoolean", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                byte result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getByte", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                byte by = result = this.wasNullX() ? (byte)0 : this.singletonRowData_.getByte(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getByte", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                short result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getShort", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                short s = result = this.wasNullX() ? (short)0 : this.singletonRowData_.getShort(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getShort", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getInt", parameterIndex);
                }
                int result = this.getIntX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getInt", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    int getIntX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? 0 : this.singletonRowData_.getInt(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getLong", parameterIndex);
                }
                long result = this.getLongX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLong", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    long getLongX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? 0L : this.singletonRowData_.getLong(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                float result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getFloat", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                float f = result = this.wasNullX() ? 0.0f : this.singletonRowData_.getFloat(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getFloat", Float.valueOf(result));
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                double result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getDouble", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                double d = result = this.wasNullX() ? 0.0 : this.singletonRowData_.getDouble(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDouble", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException, ArithmeticException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                BigDecimal result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", parameterIndex, scale);
                }
                super.checkForClosedStatement();
                this.checkForValidScale(scale);
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                BigDecimal bigDecimal = result = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(parameterIndex);
                if (result != null) {
                    result = result.setScale(scale, 1);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedExit(this, "getBigDecimal", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                BigDecimal result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBigDecimal", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                BigDecimal bigDecimal = result = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Date result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getDate", parameterIndex, cal);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                if (cal == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(parameterIndex);
                Date date = result = this.wasNullX() ? null : this.singletonRowData_.getDate(parameterIndex, cal);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDate", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Time result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTime", parameterIndex, cal);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                if (cal == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(parameterIndex);
                Time time = result = this.wasNullX() ? null : this.singletonRowData_.getTime(parameterIndex, cal);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTime", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Timestamp result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTimestamp", parameterIndex, cal);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                if (cal == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(parameterIndex);
                Timestamp timestamp = result = this.wasNullX() ? null : this.singletonRowData_.getTimestamp(parameterIndex, cal);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getString", parameterIndex);
                }
                String result = this.getStringX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getString", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    String getStringX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? null : this.singletonRowData_.getString(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBytes", parameterIndex);
                }
                byte[] result = this.getBytesX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    byte[] getBytesX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? null : this.singletonRowData_.getBytes(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Blob result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBlob", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Blob blob = result = this.wasNullX() ? null : this.singletonRowData_.getBlob(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBlob", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Clob result;
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Clob clob = result = this.wasNullX() ? null : this.singletonRowData_.getClob(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getClob", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getArray", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Array result = this.wasNullX() ? null : this.singletonRowData_.getArray(parameterIndex);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getRef", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Ref result = this.wasNullX() ? null : this.singletonRowData_.getRef(parameterIndex);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Object result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getObject", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Object object = result = this.wasNullX() ? null : this.singletonRowData_.getObject(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getObject", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getObject", parameterIndex, map);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", parameterName, sqlType);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", parameterName, sqlType, scale);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", parameterName, sqlType, typeName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getURL", parameterIndex);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setURL(String parameterName, URL x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setURL", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setNull", parameterName, sqlType);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBoolean", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setByte", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setShort", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setInt", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setLong", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setFloat", parameterName, Float.valueOf(x));
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDouble", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBigDecimal", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setString", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBytes", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDate", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTime", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTimestamp", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setAsciiStream", parameterName, x, length);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBinaryStream", parameterName, x, length);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", parameterName, x, targetSqlType, scale);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", parameterName, x, targetSqlType);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setCharacterStream", parameterName, reader, length);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDate", parameterName, x, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTime", parameterName, x, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTimestamp", parameterName, x, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setNull", parameterName, sqlType, typeName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getString", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBoolean", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getByte", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getShort", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getInt", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getLong", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getFloat", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDouble", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBytes", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDate", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTime", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTimestamp", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBigDecimal", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", parameterName, map);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getRef", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBlob", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getClob", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getArray", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDate", parameterName, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTime", parameterName, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTimestamp", parameterName, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getURL", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Reader reader = null;
                if (this.wasNull_ == 2) {
                    reader = this.singletonRowData_.getCharacterStream(parameterIndex);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public final void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setAsciiStream(String,InputStream,long)");
    }

    @Override
    public final void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBinaryStream(String,InputStream,long)");
    }

    @Override
    public final void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setCharacterStream(String,Reader,long)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getCharacterStream(String)");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(String)");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(int)");
    }

    @Override
    public String getNString(String parameterIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(String)");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (int)");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (String)");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setRowId (String, RowId)");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob(String, Blob)");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob(String, Clob)");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNString (String, String)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNString (String, Reader, long)");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String, NClob)");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob (String, Reader, long)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob (String, InputStream, long)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String, Reader, long)");
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (int)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String)");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setSQLXML (String, SQLXML)");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (int)");
    }

    @Override
    public SQLXML getSQLXML(String parametername) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (String)");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setAsciiStream(String,InputStream)");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBinaryStream(String,InputStream)");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob(String,InputStream)");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setCharacterStream(String,Reader)");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob(String,Reader)");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNCharacterStream(String,Reader)");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob(String,Reader)");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw this.mismatchException("NULL", parameterIndex);
        }
        Object retval = String.class.equals(type) ? this.getString(parameterIndex) : (BigDecimal.class.equals(type) ? this.getBigDecimal(parameterIndex) : (Boolean.class.equals(type) ? Boolean.valueOf(this.getBoolean(parameterIndex)) : (Byte.class.equals(type) ? Byte.valueOf(this.getByte(parameterIndex)) : (Short.class.equals(type) ? Short.valueOf(this.getShort(parameterIndex)) : (Integer.class.equals(type) ? Integer.valueOf(this.getInt(parameterIndex)) : (Long.class.equals(type) ? Long.valueOf(this.getLong(parameterIndex)) : (Float.class.equals(type) ? Float.valueOf(this.getFloat(parameterIndex)) : (Double.class.equals(type) ? Double.valueOf(this.getDouble(parameterIndex)) : (Date.class.equals(type) ? this.getDate(parameterIndex) : (Time.class.equals(type) ? this.getTime(parameterIndex) : (Timestamp.class.equals(type) ? this.getTimestamp(parameterIndex) : (Blob.class.equals(type) ? this.getBlob(parameterIndex) : (Clob.class.equals(type) ? this.getClob(parameterIndex) : (type.isArray() && type.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(parameterIndex) : this.getObject(parameterIndex)))))))))))))));
        if (this.wasNull()) {
            retval = null;
        }
        if (retval == null || type.isInstance(retval)) {
            return type.cast(retval);
        }
        throw this.mismatchException(type.getName(), parameterIndex);
    }

    private SQLException mismatchException(String targetTypeName, int parameterIndex) throws SQLException {
        String sourceTypeName = this.getParameterMetaData().getParameterTypeName(parameterIndex);
        ClientMessageId cmi = new ClientMessageId("22005");
        SqlException se = new SqlException(this.agent_.logWriter_, cmi, targetTypeName, sourceTypeName);
        return se.getSQLException();
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor singletonParams) {
        super.completeExecuteCall(sqlca, singletonParams);
        if (singletonParams == null) {
            return;
        }
        if (this.parameterMetaData_ == null) {
            return;
        }
        int cursorParamCount = singletonParams.columns_;
        for (int i = 0; i < cursorParamCount; ++i) {
            Object returnArg;
            if (this.parameterMetaData_.sqlxParmmode_[i] != 2) continue;
            int jdbcParamNumber = i + 1;
            try {
                returnArg = singletonParams.isNull_[i] ? null : singletonParams.getObject(jdbcParamNumber);
            }
            catch (SqlException se) {
                IllegalArgumentException iae = new IllegalArgumentException(se.getMessage());
                iae.initCause(se);
                throw iae;
            }
            if (this.parameterMetaData_.types_[i] == 5 && returnArg instanceof Integer) {
                returnArg = ((Integer)returnArg).shortValue();
            }
            this.setInput(jdbcParamNumber, returnArg);
        }
    }

    @Override
    protected String getJdbcStatementInterfaceName() {
        return "java.sql.CallableStatement";
    }

    private void checkGetterPreconditions(int parameterIndex) throws SqlException {
        super.checkForValidParameterIndex(parameterIndex);
        this.checkForValidOutParameter(parameterIndex);
    }

    private void checkForValidOutParameter(int parameterIndex) throws SqlException {
        if (this.parameterMetaData_ == null || this.parameterMetaData_.sqlxParmmode_[parameterIndex - 1] < 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ091.S"), parameterIndex);
        }
    }

    private void setWasNull(int parameterIndex) {
        this.wasNull_ = this.singletonRowData_ == null ? 0 : (this.singletonRowData_.isNull_[parameterIndex - 1] ? 1 : 2);
    }

    SQLException jdbcMethodNotImplemented() throws SQLException {
        try {
            super.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]).getSQLException();
    }
}

