/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import org.logstash.settings.Coercible;

public class Boolean
extends Coercible<java.lang.Boolean> {
    public Boolean(String name, boolean defaultValue) {
        super(name, defaultValue, true, Boolean.noValidator());
    }

    public Boolean(String name, boolean defaultValue, boolean strict) {
        super(name, defaultValue, strict, Boolean.noValidator());
    }

    @Override
    public java.lang.Boolean coerce(Object obj) {
        if (obj instanceof String) {
            switch ((String)obj) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new IllegalArgumentException(this.coercionFailureMessage(obj));
        }
        if (obj instanceof java.lang.Boolean) {
            return (java.lang.Boolean)obj;
        }
        throw new IllegalArgumentException(this.coercionFailureMessage(obj));
    }

    private String coercionFailureMessage(Object obj) {
        return String.format("Cannot coerce `%s` to boolean (%s)", obj, this.getName());
    }
}

