/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.shared.common.error.StandardException;

public final class ActiveLock
extends Lock {
    byte wakeUpNow;
    boolean potentiallyGranted;
    protected boolean canSkip;

    protected ActiveLock(CompatibilitySpace space, Lockable ref, Object qualifier) {
        super(space, ref, qualifier);
    }

    protected boolean setPotentiallyGranted() {
        if (!this.potentiallyGranted) {
            this.potentiallyGranted = true;
            return true;
        }
        return false;
    }

    protected void clearPotentiallyGranted() {
        this.potentiallyGranted = false;
    }

    protected synchronized byte waitForGrant(int timeout) throws StandardException {
        if (this.wakeUpNow == 0) {
            try {
                if (timeout == -1) {
                    this.wait();
                } else if (timeout > 0) {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException ie) {
                this.wakeUpNow = (byte)3;
            }
        }
        byte why = this.wakeUpNow;
        this.wakeUpNow = 0;
        return why;
    }

    protected synchronized void wakeUp(byte why) {
        if (this.wakeUpNow != 2) {
            this.wakeUpNow = why;
        }
        this.notify();
    }
}

