/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.StylesheetPackage;

public class PackageLibrary {
    Map<String, List<StylesheetPackage>> packageMap = new HashMap<String, List<StylesheetPackage>>();

    public void addPackage(String name, StylesheetPackage packageIn) {
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            list = new ArrayList<StylesheetPackage>();
            list.add(packageIn);
            this.packageMap.put(name, list);
        } else {
            for (StylesheetPackage p : list) {
                if (!p.getPackageVersion().equals(packageIn.getPackageVersion())) continue;
                list.remove(p);
                list.add(packageIn);
                return;
            }
            list.add(packageIn);
        }
    }

    public StylesheetPackage getPackage(String name, PackageVersionRanges ranges) {
        List<StylesheetPackage> list = this.packageMap.get(name);
        for (StylesheetPackage p : list) {
            if (!ranges.contains(p.getPackageVersion())) continue;
            return p;
        }
        return null;
    }

    public StylesheetPackage getPackage(String name) {
        PackageVersion latestVersion = null;
        StylesheetPackage latestPackage = null;
        List<StylesheetPackage> list = this.packageMap.get(name);
        if (list == null) {
            return null;
        }
        for (StylesheetPackage p : list) {
            if (latestVersion != null && latestVersion.compareTo(p.getPackageVersion()) != -1) continue;
            latestVersion = p.getPackageVersion();
            latestPackage = p;
        }
        return latestPackage;
    }

    public int size(String name) {
        return this.packageMap.get(name).size();
    }
}

