/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VennPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private int nodeKind = 0;

    public VennPattern(Pattern p1, Pattern p2) {
        this.p1 = p1;
        this.p2 = p2;
        if (p1.getNodeKind() == p2.getNodeKind()) {
            this.nodeKind = p1.getNodeKind();
        }
        this.setPackageData(p1.getPackageData());
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.p1 = this.p1.simplify(visitor);
        this.p2 = this.p2.simplify(visitor);
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.mustBeNodePattern(this.p1);
        this.p1 = this.p1.analyze(visitor, contextItemType);
        this.mustBeNodePattern(this.p2);
        this.p2 = this.p2.analyze(visitor, contextItemType);
        return this;
    }

    private void mustBeNodePattern(Pattern p) throws XPathException {
        ItemType it;
        if (p instanceof NodeTestPattern && !((it = p.getItemType()) instanceof NodeTest)) {
            XPathException err = new XPathException("The operands of a union, intersect, or except pattern must be patterns that match nodes", "XPTY0004");
            err.setIsTypeError(true);
            throw err;
        }
    }

    @Override
    public void bindCurrent(LocalBinding binding) {
        this.p1.bindCurrent(binding);
        this.p2.bindCurrent(binding);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.p1.promote(offer, parent);
        this.p2.promote(offer, parent);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        return this.p1.replaceSubExpression(original, replacement) || this.p2.replaceSubExpression(original, replacement);
    }

    @Override
    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        this.p1.setOriginalText(pattern);
        this.p2.setOriginalText(pattern);
    }

    @Override
    public boolean isMotionless(boolean allowExtensions) {
        return this.p1.isMotionless(allowExtensions) && this.p2.isMotionless(allowExtensions);
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        nextFree = this.p1.allocateSlots(slotManager, nextFree);
        nextFree = this.p2.allocateSlots(slotManager, nextFree);
        return nextFree;
    }

    public void gatherComponentPatterns(Set<Pattern> set) {
        if (this.p1 instanceof VennPattern) {
            ((VennPattern)this.p1).gatherComponentPatterns(set);
        } else {
            set.add(this.p1);
        }
        if (this.p2 instanceof VennPattern) {
            ((VennPattern)this.p2).gatherComponentPatterns(set);
        } else {
            set.add(this.p2);
        }
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public ItemType getItemType() {
        if (this.nodeKind == 0) {
            return AnyNodeTest.getInstance();
        }
        if (this.nodeKind == -1) {
            return AnyItemType.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    @Override
    public int getDependencies() {
        return this.p1.getDependencies() | this.p2.getDependencies();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MultiIterator<Expression>(new Iterator[]{this.p1.iterateSubExpressions(), this.p2.iterateSubExpressions()});
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.p1.setSystemId(systemId);
        this.p2.setSystemId(systemId);
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        this.p1.setLineNumber(lineNumber);
        this.p2.setLineNumber(lineNumber);
    }

    public boolean equals(Object other) {
        if (other instanceof VennPattern) {
            HashSet<Pattern> s0 = new HashSet<Pattern>(10);
            this.gatherComponentPatterns(s0);
            HashSet<Pattern> s1 = new HashSet<Pattern>(10);
            ((VennPattern)other).gatherComponentPatterns(s1);
            return s0.equals(s1);
        }
        return false;
    }

    public int hashCode() {
        return 0x9BD723A6 ^ this.p1.hashCode() ^ this.p2.hashCode();
    }
}

