/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class UserType
extends DataType
implements UserDataValue {
    private Object value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(UserType.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += ClassSize.estimateAndCatalogBase(this.value.getClass());
        }
        return sz;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean() throws StandardException {
        if (!this.isNull() && this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return super.getBoolean();
    }

    @Override
    public byte getByte() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return super.getByte();
    }

    @Override
    public short getShort() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return super.getShort();
    }

    @Override
    public int getInt() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return super.getInt();
    }

    @Override
    public long getLong() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return super.getLong();
    }

    @Override
    public float getFloat() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return super.getFloat();
    }

    @Override
    public double getDouble() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return super.getDouble();
    }

    @Override
    public byte[] getBytes() throws StandardException {
        if (!this.isNull() && this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return super.getBytes();
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Date) {
                return (Date)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getDate(cal);
            }
        }
        return super.getDate(cal);
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Time) {
                return (Time)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getTime(cal);
            }
        }
        return super.getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Timestamp) {
                return (Timestamp)this.value;
            }
            if (this.value instanceof Date) {
                return new SQLDate((Date)this.value).getTimestamp(cal);
            }
            if (this.value instanceof Time) {
                return new SQLTime((Time)this.value).getTimestamp(cal);
            }
        }
        return super.getTimestamp(cal);
    }

    @Override
    void setObject(Object theValue) {
        this.setValue(theValue);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getTypeName() {
        return this.isNull() ? "JAVA_OBJECT" : ClassInspector.readableClassName(this.value.getClass());
    }

    @Override
    String getTypeName(String className) {
        return className;
    }

    @Override
    public int getTypeFormatId() {
        return 266;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new UserType(this.value);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new UserType();
    }

    @Override
    public void restoreToNull() {
        this.value = null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getObject(colNumber);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        int comparison;
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        try {
            comparison = ((Comparable)this.value).compareTo(other.getObject());
        }
        catch (ClassCastException cce) {
            throw StandardException.newException((String)"XCL15.S", (Object[])new Object[]{this.getTypeName(), ClassInspector.readableClassName(other.getObject().getClass())});
        }
        if (comparison < 0) {
            comparison = -1;
        } else if (comparison > 0) {
            comparison = 1;
        }
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        Object o;
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        if (!(op != 2 || this.isNull() || other.isNull() || (o = this.getObject()) instanceof Comparable)) {
            return o.equals(other.getObject());
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public UserType() {
    }

    public UserType(Object value) {
        this.value = value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getObject());
    }

    @Override
    public void setBigDecimal(BigDecimal theValue) {
        this.setValue(theValue);
    }

    @Override
    public void setValue(String theValue) {
        this.value = theValue == null ? null : theValue;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(2, right, true, false));
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, !left.compare(2, right, true, false));
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.hashCode();
    }

    @Override
    public int typePrecedence() {
        return 1000;
    }

    @Override
    public final boolean isNull() {
        return this.value == null;
    }
}

