/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.psych.PsychEmitter;
import org.jruby.ext.psych.PsychParser;
import org.jruby.ext.psych.PsychToRuby;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class PsychLibrary
implements Library {
    private static final String DUMMY_VERSION = "0.0";

    public void load(Ruby ruby, boolean bl) {
        Object object;
        RubyModule rubyModule = ruby.defineModule("Psych");
        Properties properties = new Properties();
        try {
            object = ruby.getJRubyClassLoader().getResourceAsStream("META-INF/maven/org.snakeyaml/snakeyaml-engine/pom.properties");
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = properties.getProperty("version", DUMMY_VERSION);
        if (((String)object).endsWith("-SNAPSHOT")) {
            object = ((String)object).substring(0, ((String)object).length() - "-SNAPSHOT".length());
        }
        RubyString rubyString = ruby.newString((String)object + ".0");
        rubyString.setFrozen(true);
        rubyModule.setConstant("SNAKEYAML_VERSION", (IRubyObject)rubyString);
        String[] stringArray = rubyString.toString().split("\\.");
        final RubyArray rubyArray = ruby.newArray(new IRubyObject[]{ruby.newFixnum(Integer.parseInt(stringArray[0])), ruby.newFixnum(Integer.parseInt(stringArray[1])), ruby.newFixnum(Integer.parseInt(stringArray[2]))});
        rubyArray.setFrozen(true);
        rubyModule.getSingletonClass().addMethod("libyaml_version", (DynamicMethod)new JavaMethod.JavaMethodZero(this, rubyModule, Visibility.PUBLIC){
            final /* synthetic */ PsychLibrary this$0;
            {
                this.this$0 = psychLibrary;
                super(rubyModule, visibility);
            }

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                return rubyArray;
            }
        });
        PsychParser.initPsychParser(ruby, rubyModule);
        PsychEmitter.initPsychEmitter(ruby, rubyModule);
        PsychToRuby.initPsychToRuby(ruby, rubyModule);
    }

    public static enum YAMLEncoding {
        YAML_ANY_ENCODING((Encoding)UTF8Encoding.INSTANCE),
        YAML_UTF8_ENCODING((Encoding)UTF8Encoding.INSTANCE),
        YAML_UTF16LE_ENCODING((Encoding)UTF16LEEncoding.INSTANCE),
        YAML_UTF16BE_ENCODING((Encoding)UTF16BEEncoding.INSTANCE);

        public final Encoding encoding;

        private YAMLEncoding(Encoding encoding) {
            this.encoding = encoding;
        }
    }
}

