/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;

public class TableUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TableUtils.class);
    public static final int ROWSTATUS_ACTIVE = 1;
    public static final int ROWSTATUS_NOTINSERVICE = 2;
    public static final int ROWSTATUS_NOTREADY = 3;
    public static final int ROWSTATUS_CREATEANDGO = 4;
    public static final int ROWSTATUS_CREATEANDWAIT = 5;
    public static final int ROWSTATUS_DESTROY = 6;
    private int maxNumOfRowsPerPDU = 10;
    private int maxNumColumnsPerPDU = 10;
    private boolean sendColumnPDUsMultiThreaded;
    private boolean checkLexicographicOrdering = true;
    private int ignoreMaxLexicographicRowOrderingErrors = 3;
    private int rowLimit = 0;

    public TableUtils(Session snmpSession, PDUFactory pduFactory) {
        super(snmpSession, pduFactory);
    }

    public List<TableEvent> getTable(Target<?> target, OID[] columnOIDs, OID lowerBoundIndex, OID upperBoundIndex) {
        return this.getTable(target, columnOIDs, lowerBoundIndex, upperBoundIndex, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableEvent> getTable(Target<?> target, OID[] columnOIDs, OID lowerBoundIndex, OID upperBoundIndex, long timeoutSeconds) {
        if (columnOIDs == null || columnOIDs.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        InternalTableListener listener = new InternalTableListener();
        TableRequest req = this.createTableRequest(target, columnOIDs, listener, null, lowerBoundIndex, upperBoundIndex, SparseTableMode.sparseTable);
        InternalTableListener internalTableListener = listener;
        synchronized (internalTableListener) {
            if (req.sendNextChunk()) {
                try {
                    listener.wait(timeoutSeconds * 1000L);
                    if (!listener.finished) {
                        listener.finished = true;
                        listener.rows.add(new TableEvent(req, null, -1));
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return listener.getRows();
    }

    protected TableRequest createTableRequest(Target<?> target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex, SparseTableMode sparseTableMode) {
        return new TableRequest(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex, sparseTableMode);
    }

    public void getTable(Target<?> target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex, SparseTableMode sparseTableMode) {
        if (columnOIDs == null || columnOIDs.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        TableRequest req = new TableRequest(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex, sparseTableMode);
        boolean sendMore = req.sendNextChunk();
        while (this.sendColumnPDUsMultiThreaded && sendMore) {
            sendMore = req.sendNextChunk();
        }
    }

    public void getTable(Target<?> target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
        this.getTable(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex, SparseTableMode.sparseTable);
    }

    public void getDenseTable(Target<?> target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
        if (columnOIDs == null || columnOIDs.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        TableRequest req = new TableRequest(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex, SparseTableMode.denseTableDropIncompleteRows);
        req.sendNextChunk();
    }

    public int getMaxNumRowsPerPDU() {
        return this.maxNumOfRowsPerPDU;
    }

    public void setMaxNumRowsPerPDU(int numberOfRowsPerChunk) {
        if (numberOfRowsPerChunk < 1) {
            throw new IllegalArgumentException("The number of rows per PDU must be > 0");
        }
        this.maxNumOfRowsPerPDU = numberOfRowsPerChunk;
    }

    public int getMaxNumColumnsPerPDU() {
        return this.maxNumColumnsPerPDU;
    }

    public void setMaxNumColumnsPerPDU(int numberOfColumnsPerChunk) {
        if (numberOfColumnsPerChunk < 1) {
            throw new IllegalArgumentException("The number of columns per PDU must be > 0");
        }
        this.maxNumColumnsPerPDU = numberOfColumnsPerChunk;
    }

    public boolean isSendColumnPDUsMultiThreaded() {
        return this.sendColumnPDUsMultiThreaded;
    }

    public void setSendColumnPDUsMultiThreaded(boolean sendColumnPDUsMultiThreaded) {
        this.sendColumnPDUsMultiThreaded = sendColumnPDUsMultiThreaded;
    }

    public boolean isCheckLexicographicOrdering() {
        return this.checkLexicographicOrdering;
    }

    public int getIgnoreMaxLexicographicRowOrderingErrors() {
        return this.ignoreMaxLexicographicRowOrderingErrors;
    }

    public void setIgnoreMaxLexicographicRowOrderingErrors(int ignoreMaxLexicographicRowOrderingErrors) {
        this.ignoreMaxLexicographicRowOrderingErrors = ignoreMaxLexicographicRowOrderingErrors;
    }

    public void setCheckLexicographicOrdering(boolean checkLexicographicOrdering) {
        this.checkLexicographicOrdering = checkLexicographicOrdering;
    }

    public <A extends Address> ResponseEvent<A> createRow(Target<A> target, OID rowStatusColumnOID, OID rowIndex, VariableBinding[] values) {
        PDU pdu = this.pduFactory.createPDU(target);
        OID rowStatusID = new OID(rowStatusColumnOID);
        rowStatusID.append(rowIndex);
        VariableBinding rowStatus = new VariableBinding(rowStatusID);
        if (values != null) {
            rowStatus.setVariable(new Integer32(4));
        } else {
            rowStatus.setVariable(new Integer32(5));
        }
        pdu.add(rowStatus);
        if (values != null) {
            for (VariableBinding value : values) {
                OID columnOID = new OID(value.getOid());
                columnOID.append(rowIndex);
                value.setOid(columnOID);
            }
            pdu.addAll(values);
        }
        pdu.setType(-93);
        try {
            return this.session.send(pdu, target);
        }
        catch (IOException ex) {
            logger.error(ex);
            return null;
        }
    }

    public <A extends Address> ResponseEvent<A> destroyRow(Target<A> target, OID rowStatusColumnOID, OID rowIndex) {
        PDU pdu = this.pduFactory.createPDU(target);
        OID rowStatusID = new OID(rowStatusColumnOID);
        rowStatusID.append(rowIndex);
        VariableBinding rowStatus = new VariableBinding(rowStatusID);
        rowStatus.setVariable(new Integer32(6));
        pdu.add(rowStatus);
        pdu.setType(-93);
        try {
            ResponseEvent<A> responseEvent = this.session.send(pdu, target);
            return responseEvent;
        }
        catch (IOException ex) {
            logger.error(ex);
            return null;
        }
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    protected class InternalTableListener
    implements TableListener {
        private List<TableEvent> rows = new LinkedList<TableEvent>();
        private volatile boolean finished = false;

        protected InternalTableListener() {
        }

        @Override
        public boolean next(TableEvent event) {
            this.rows.add(event);
            return true;
        }

        @Override
        public synchronized void finished(TableEvent event) {
            if (event.getStatus() != 0 || event.getIndex() != null) {
                this.rows.add(event);
            }
            this.finished = true;
            this.notifyAll();
        }

        public List<TableEvent> getRows() {
            return this.rows;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    public static enum SparseTableMode {
        sparseTable,
        denseTableDropIncompleteRows,
        denseTableDoubleCheckIncompleteRows;

    }

    public class TableRequest
    implements ResponseListener {
        Target<?> target;
        OID[] columnOIDs;
        TableListener listener;
        Object userObject;
        OID lowerBoundIndex;
        OID upperBoundIndex;
        private int sent = 0;
        private boolean anyMatch = false;
        private List<OID> lastSent = null;
        private final LinkedList<Row> rowCache = new LinkedList();
        protected LastReceived lastReceived;
        private int requestSerial = Integer.MIN_VALUE;
        private final List<Integer> requestSerialsPending = Collections.synchronizedList(new LinkedList());
        private int numLexicographicErrors = 0;
        volatile boolean finished = false;
        private final SparseTableMode sparseTableMode;
        protected int rowsRetrieved = 0;
        protected int rowsReleased = 0;
        private OID lastMinIndex = null;

        public TableRequest(Target<?> target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex, SparseTableMode sparseTableMode) {
            this.target = target;
            this.columnOIDs = columnOIDs;
            this.listener = listener;
            this.userObject = userObject;
            this.lastReceived = new LastReceived(Arrays.asList(columnOIDs));
            this.upperBoundIndex = upperBoundIndex;
            this.lowerBoundIndex = lowerBoundIndex;
            if (lowerBoundIndex != null) {
                for (int i = 0; i < this.lastReceived.size(); ++i) {
                    OID oid = new OID(this.lastReceived.get(i));
                    oid.append(lowerBoundIndex);
                    this.lastReceived.set(i, oid);
                }
            }
            this.sparseTableMode = sparseTableMode;
        }

        public SparseTableMode getSparseTableMode() {
            return this.sparseTableMode;
        }

        public int getNumLexicographicErrors() {
            return this.numLexicographicErrors;
        }

        public boolean sendNextChunk() {
            if (this.sent >= this.lastReceived.size()) {
                return false;
            }
            PDU pdu = TableUtils.this.pduFactory.createPDU(this.target);
            if (this.target.getVersion() == 0) {
                pdu.setType(-95);
            } else if (pdu.getType() != -95) {
                pdu.setType(-91);
            }
            int sz = Math.min(this.lastReceived.size() - this.sent, TableUtils.this.maxNumColumnsPerPDU);
            if (pdu.getType() == -91) {
                if (TableUtils.this.maxNumOfRowsPerPDU > 0) {
                    pdu.setMaxRepetitions(TableUtils.this.maxNumOfRowsPerPDU);
                    pdu.setNonRepeaters(0);
                } else {
                    pdu.setNonRepeaters(sz);
                    pdu.setMaxRepetitions(0);
                }
            }
            this.lastSent = new ArrayList<OID>(sz + 1);
            ArrayList<Integer> sentColumns = new ArrayList<Integer>(sz);
            int chunkSize = 0;
            for (int i = this.sent; i < this.sent + sz; ++i) {
                OID col = this.lastReceived.get(i);
                if (col.startsWith(this.columnOIDs[i])) {
                    VariableBinding vb = new VariableBinding(col);
                    pdu.add(vb);
                    if (pdu.getBERLength() > this.target.getMaxSizeRequestPDU()) {
                        pdu.trim();
                        break;
                    }
                    this.lastSent.add(this.lastReceived.get(i));
                    ++chunkSize;
                    sentColumns.add(i);
                    continue;
                }
                ++chunkSize;
                if (this.sent + sz < this.lastReceived.size()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Empty column instance detected at col " + i + ": " + String.valueOf(col) + " != " + String.valueOf(this.columnOIDs[i]))));
                    }
                    ++sz;
                }
                if (i + 1 != this.columnOIDs.length) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Last column finished, releasing row cache up to index " + String.valueOf(this.lastMinIndex))));
                }
                this.releaseCache(this.lastMinIndex);
            }
            try {
                this.sent += chunkSize;
                if (pdu.size() == 0) {
                    return false;
                }
                ColumnsOfRequest columnsOfRequest = new ColumnsOfRequest(sentColumns, this.requestSerial++, TableUtils.this.isCheckLexicographicOrdering() ? new LastReceived(this.lastReceived) : null);
                this.sendRequest(pdu, this.target, columnsOfRequest);
            }
            catch (Exception ex) {
                logger.error(ex);
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                this.listener.finished(new TableEvent(this, this.userObject, ex));
                return false;
            }
            return true;
        }

        protected void sendRequest(PDU pdu, Target<?> target, ColumnsOfRequest sendColumns) throws IOException {
            this.requestSerialsPending.add(sendColumns.getRequestSerial());
            TableUtils.this.session.send(pdu, target, sendColumns, this);
        }

        protected synchronized boolean removePending(int requestSerial) {
            boolean inOrder = true;
            Iterator<Integer> it = this.requestSerialsPending.iterator();
            while (it.hasNext()) {
                int pendingRequestSerial = it.next();
                if (pendingRequestSerial == requestSerial) {
                    it.remove();
                    continue;
                }
                inOrder = false;
            }
            return inOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A extends Address> void onResponse(ResponseEvent<A> event) {
            TableUtils.this.session.cancel(event.getRequest(), this);
            if (this.finished) {
                return;
            }
            TableRequest tableRequest = this;
            synchronized (tableRequest) {
                if (this.checkResponse(event)) {
                    boolean sentChunk;
                    Row firstCacheRow;
                    boolean anyMatchInChunk = false;
                    ColumnsOfRequest colsOfRequest = (ColumnsOfRequest)event.getUserObject();
                    boolean receivedInOrder = this.removePending(colsOfRequest.getRequestSerial());
                    PDU request = event.getRequest();
                    PDU response = event.getResponse();
                    int cols = request.size();
                    int rows = response.size() / cols;
                    OID nextMinIndex = null;
                    for (int r = 0; r < rows; ++r) {
                        Row row = null;
                        anyMatchInChunk = false;
                        for (int c = 0; c < cols; ++c) {
                            OID col;
                            int pos = colsOfRequest.getColumnIDs().get(c);
                            VariableBinding vb = response.get(r * cols + c);
                            if (vb.isException()) continue;
                            OID id = vb.getOid();
                            if (id.startsWith(col = this.columnOIDs[pos])) {
                                OID index = new OID(id.getValue(), col.size(), id.size() - col.size());
                                if (this.upperBoundIndex != null && index.compareTo(this.upperBoundIndex) > 0) continue;
                                if (nextMinIndex == null || index.compareTo(nextMinIndex) < 0) {
                                    nextMinIndex = index;
                                }
                                anyMatchInChunk = true;
                                if (row == null || !row.getRowIndex().equals(index)) {
                                    row = null;
                                    row = this.getRowFromCache(row, index);
                                }
                                if (row == null) {
                                    row = new Row(index);
                                    this.appendOrInsertNewRowToCache(row, index);
                                    ++this.rowsRetrieved;
                                }
                                row.setNumComplete(pos);
                                if (pos < row.getNumComplete()) {
                                    row.set(pos, vb);
                                } else {
                                    row.add(vb);
                                }
                                if (TableUtils.this.isCheckLexicographicOrdering()) {
                                    OID requested = event.getRequest().get(c).getOid();
                                    if (id.compareTo(requested) <= 0) {
                                        if (!row.orderError) {
                                            row.orderError = true;
                                        }
                                    } else if (colsOfRequest.lastReceived != null) {
                                        try {
                                            Row baseRow = colsOfRequest.lastReceived.getColumnInfos().get(pos).getBasedOn();
                                            if (baseRow != null && baseRow.isOrderError()) {
                                                row.orderError = true;
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                this.lastReceived.set(pos, vb.getOid(), row);
                                continue;
                            }
                            this.lastReceived.set(pos, vb.getOid());
                        }
                    }
                    if (TableUtils.this.getRowLimit() > 0 && this.rowsRetrieved >= TableUtils.this.getRowLimit()) {
                        for (int i = this.rowsRetrieved - TableUtils.this.getRowLimit(); i > 0 && !this.rowCache.isEmpty(); --i) {
                            Row lastRow = this.rowCache.removeLast();
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Serializable)((Object)("Removing off limit row from cache with index = " + String.valueOf(lastRow.index))));
                        }
                        this.finishRequest(-5);
                        return;
                    }
                    this.anyMatch |= anyMatchInChunk;
                    this.lastMinIndex = nextMinIndex;
                    while (!((firstCacheRow = this.rowCache.isEmpty() ? null : this.rowCache.getFirst()) == null || firstCacheRow.getNumComplete() != this.columnOIDs.length || !receivedInOrder || this.sparseTableMode != SparseTableMode.sparseTable && firstCacheRow.hasNullValues() || this.lastMinIndex != null && !firstCacheRow.orderError && firstCacheRow.getRowIndex().compareTo(nextMinIndex) >= 0)) {
                        TableEvent tableEvent = this.getNextTableEvent();
                        ++this.rowsReleased;
                        if (TableUtils.this.isCheckLexicographicOrdering() && tableEvent != null && tableEvent.status == -2 && this.numLexicographicErrors >= TableUtils.this.ignoreMaxLexicographicRowOrderingErrors) {
                            if (TableUtils.this.ignoreMaxLexicographicRowOrderingErrors > 0) {
                                this.listener.next(tableEvent);
                            }
                            this.finishRequest(-2);
                            return;
                        }
                        if (tableEvent != null && this.listener.next(tableEvent)) continue;
                        this.finishRequest(this.getTableStatus());
                        return;
                    }
                    if (this.sparseTableMode == SparseTableMode.denseTableDoubleCheckIncompleteRows && firstCacheRow != null && firstCacheRow.hasNullValues()) {
                        ResponseListener responseListener = new ResponseListener(){

                            @Override
                            public <A extends Address> void onResponse(ResponseEvent<A> event) {
                                Row cachedRow = (Row)event.getUserObject();
                                if (event.getResponse() != null && event.getResponse().getErrorStatus() == 0) {
                                    for (VariableBinding variableBinding : event.getResponse().getVariableBindings()) {
                                        if (!variableBinding.isException()) {
                                            for (int i = 0; i < TableRequest.this.columnOIDs.length; ++i) {
                                                if (!variableBinding.getOid().startsWith(TableRequest.this.columnOIDs[i])) continue;
                                                cachedRow.set(i, variableBinding);
                                                if (!logger.isDebugEnabled()) continue;
                                                logger.debug((Serializable)((Object)("Received column " + i + " for recently appeared row " + String.valueOf(cachedRow.index) + " with GET request: " + String.valueOf(variableBinding) + ", row.firstNullValueIndex=" + cachedRow.firstNullValue)));
                                            }
                                            continue;
                                        }
                                        if (!logger.isDebugEnabled()) continue;
                                        logger.debug((Serializable)((Object)("Row " + String.valueOf(cachedRow.index) + " has been removed because " + String.valueOf(variableBinding) + " returned exception")));
                                    }
                                } else if (event.getResponse() == null) {
                                    TableRequest.this.finishRequest(-1);
                                } else {
                                    TableRequest.this.finishRequest(event.getResponse().getErrorStatus());
                                }
                            }
                        };
                        PDU pdu = TableUtils.this.pduFactory.createPDU(this.target);
                        pdu.setType(-96);
                        for (int i = 0; i < firstCacheRow.size(); ++i) {
                            if (firstCacheRow.get(i) == null) {
                                OID colOID = new OID(this.columnOIDs[i].getValue(), firstCacheRow.index.getValue());
                                pdu.add(new VariableBinding(colOID));
                            }
                            if (pdu.size() < TableUtils.this.maxNumColumnsPerPDU) continue;
                            pdu = this.sendGetPDU(firstCacheRow, responseListener, pdu);
                        }
                        if (pdu.size() > 0) {
                            this.sendGetPDU(firstCacheRow, responseListener, pdu);
                        }
                    }
                    if (receivedInOrder && !(sentChunk = this.sendNextChunk())) {
                        if (this.anyMatch) {
                            this.sent = 0;
                            this.anyMatch = false;
                            sentChunk = this.sendNextChunk();
                        }
                        if (!sentChunk) {
                            this.finishRequest(this.getTableStatus());
                        }
                    }
                }
            }
        }

        private void appendOrInsertNewRowToCache(Row row, OID index) {
            if (this.rowCache.isEmpty()) {
                this.rowCache.add(row);
            } else if (this.rowCache.getFirst().getRowIndex().compareTo(index) >= 0) {
                this.rowCache.addFirst(row);
            } else {
                this.insertRowIntoCache(row, index);
            }
        }

        private void insertRowIntoCache(Row row, OID index) {
            ListIterator<Row> it = this.rowCache.listIterator(this.rowCache.size());
            while (it.hasPrevious()) {
                Row lastRow = it.previous();
                if (index.compareTo(lastRow.index) < 0) continue;
                it.set(row);
                it.add(lastRow);
                break;
            }
        }

        private Row getRowFromCache(Row row, OID index) {
            ListIterator<Row> it = this.rowCache.listIterator(this.rowCache.size());
            while (it.hasPrevious()) {
                Row lastRow = it.previous();
                int compareResult = index.compareTo(lastRow.getRowIndex());
                if (compareResult == 0) {
                    row = lastRow;
                    break;
                }
                if (compareResult <= 0) continue;
                break;
            }
            return row;
        }

        private void finishRequest(int tableEventStatus) {
            this.releaseCache();
            this.finished = true;
            this.listener.finished(new TableEvent(this, this.userObject, tableEventStatus));
        }

        protected PDU sendGetPDU(Row firstCacheRow, ResponseListener responseListener, PDU pdu) {
            try {
                TableUtils.this.session.send(pdu, this.target, firstCacheRow, responseListener);
                pdu = TableUtils.this.pduFactory.createPDU(this.target);
                pdu.setType(-96);
            }
            catch (IOException e) {
                logger.error(e);
            }
            return pdu;
        }

        protected int getTableStatus() {
            return this.numLexicographicErrors > 0 ? -2 : 0;
        }

        protected <A extends Address> boolean checkResponse(ResponseEvent<A> event) {
            if (this.finished) {
                return false;
            }
            if (event.getError() != null) {
                this.finished = true;
                this.releaseCache();
                this.listener.finished(new TableEvent(this, this.userObject, event.getError()));
            } else if (event.getResponse() == null) {
                this.finished = true;
                this.releaseCache();
                this.listener.finished(new TableEvent(this, this.userObject, -1));
            } else if (event.getResponse().getType() == -88) {
                this.finished = true;
                this.releaseCache();
                this.listener.finished(new TableEvent(this, this.userObject, event.getResponse()));
            } else if (event.getResponse().getErrorStatus() != 0) {
                this.finished = true;
                this.releaseCache();
                this.listener.finished(new TableEvent(this, this.userObject, event.getResponse().getErrorStatus()));
            } else {
                return true;
            }
            return false;
        }

        private void releaseCache(OID upperBoundIndex) {
            while (this.rowCache.size() > 0 && (upperBoundIndex == null || upperBoundIndex.compareTo(this.rowCache.getFirst().index) > 0)) {
                TableEvent tableEvent = this.getNextTableEvent();
                if (tableEvent == null || tableEvent.getStatus() == -2 && this.numLexicographicErrors > TableUtils.this.ignoreMaxLexicographicRowOrderingErrors) continue;
                ++this.rowsReleased;
                if (this.listener.next(tableEvent)) continue;
                break;
            }
        }

        private void releaseCache() {
            this.releaseCache(null);
        }

        private TableEvent getNextTableEvent() {
            if (this.rowCache.isEmpty()) {
                return null;
            }
            Row r = this.rowCache.removeFirst();
            r.setNumComplete(this.columnOIDs.length);
            while (this.sparseTableMode != SparseTableMode.sparseTable && r.hasNullValues() && !this.rowCache.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("TableUtils dropped incomplete row " + String.valueOf(r) + " because mode is " + String.valueOf((Object)this.sparseTableMode))));
                }
                try {
                    r = this.rowCache.removeFirst();
                    r.setNumComplete(this.columnOIDs.length);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            VariableBinding[] vbs = new VariableBinding[r.size()];
            vbs = r.toArray(vbs);
            TableEvent tableEvent = new TableEvent(this, this.userObject, r.getRowIndex(), vbs);
            if (r.isOrderError()) {
                tableEvent.status = -2;
                ++this.numLexicographicErrors;
            }
            return tableEvent;
        }

        public Row getRow(OID index) {
            ListIterator<Row> it = this.rowCache.listIterator(this.rowCache.size() + 1);
            while (it.hasPrevious()) {
                Row r = it.previous();
                if (!index.equals(r.getRowIndex())) continue;
                return r;
            }
            return null;
        }
    }

    protected class Row
    extends ArrayList<VariableBinding> {
        private static final long serialVersionUID = -2297277440117636627L;
        private OID index;
        private boolean orderError;
        private int firstNullValue = -1;

        public Row(OID index) {
            this.index = index;
        }

        public boolean isOrderError() {
            return this.orderError;
        }

        public OID getRowIndex() {
            return this.index;
        }

        public int getNumComplete() {
            return super.size();
        }

        public int setNumComplete(int numberOfColumnsComplete) {
            int startSize = this.getNumComplete();
            int newSize = numberOfColumnsComplete - startSize;
            for (int i = 0; i < newSize; ++i) {
                super.add(null);
            }
            if (newSize > 0) {
                this.firstNullValue = startSize;
            }
            return newSize;
        }

        public boolean hasNullValues() {
            return this.firstNullValue >= 0 && this.firstNullValue < this.size();
        }

        @Override
        public VariableBinding set(int index, VariableBinding element) {
            VariableBinding newVB = super.set(index, element);
            if (this.firstNullValue == index && element != null) {
                while (this.firstNullValue < this.size() && this.get(this.firstNullValue) != null) {
                    ++this.firstNullValue;
                }
                if (this.firstNullValue >= this.size()) {
                    this.firstNullValue = -1;
                }
            }
            return newVB;
        }
    }

    protected class LastReceivedColumnInfo {
        private OID oid;
        private Row basedOn;

        public LastReceivedColumnInfo(OID oid, Row basedOn) {
            this.oid = oid;
            this.basedOn = basedOn;
        }

        public OID getOid() {
            return this.oid;
        }

        public Row getBasedOn() {
            return this.basedOn;
        }

        public String toString() {
            return "LastReceivedColumnInfo{oid=" + String.valueOf(this.oid) + ", basedOn=" + String.valueOf(this.basedOn) + "}";
        }
    }

    protected class LastReceived {
        private List<LastReceivedColumnInfo> columnInfos;

        public LastReceived(LastReceived otherLastReceived) {
            this.columnInfos = new ArrayList<LastReceivedColumnInfo>(otherLastReceived.size());
            for (LastReceivedColumnInfo columnInfo : otherLastReceived.columnInfos) {
                this.columnInfos.add(columnInfo);
            }
        }

        public LastReceived(List<OID> plainColumnInfos) {
            this.columnInfos = new ArrayList<LastReceivedColumnInfo>(plainColumnInfos.size());
            for (OID columnOID : plainColumnInfos) {
                this.columnInfos.add(new LastReceivedColumnInfo(columnOID, null));
            }
        }

        public void setColumnInfos(List<LastReceivedColumnInfo> columnInfos) {
            this.columnInfos = columnInfos;
        }

        public List<LastReceivedColumnInfo> getColumnInfos() {
            return this.columnInfos;
        }

        public int size() {
            return this.columnInfos.size();
        }

        public OID get(int i) {
            return this.columnInfos.get(i).getOid();
        }

        public void set(int i, OID oid) {
            this.columnInfos.set(i, new LastReceivedColumnInfo(oid, null));
        }

        public void set(int i, OID oid, Row baseRow) {
            this.columnInfos.set(i, new LastReceivedColumnInfo(oid, baseRow));
        }

        public String toString() {
            return "LastReceived{columnInfos=" + String.valueOf(this.columnInfos) + "}";
        }
    }

    protected class DenseTableRequest
    extends TableRequest {
        protected DenseTableRequest(Target<?> target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
            super(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex, SparseTableMode.denseTableDropIncompleteRows);
        }

        @Override
        public synchronized <A extends Address> void onResponse(ResponseEvent<A> event) {
            TableUtils.this.session.cancel(event.getRequest(), this);
            if (this.finished) {
                return;
            }
            if (this.checkResponse(event)) {
                int startCol = (Integer)event.getUserObject();
                PDU request = event.getRequest();
                PDU response = event.getResponse();
                int cols = request.size();
                int rows = response.size() / cols;
                OID lastMinIndex = null;
                for (int r = 0; r < rows; ++r) {
                    Row row = null;
                    for (int c = 0; c < request.size(); ++c) {
                        OID col;
                        OID id;
                        int pos = startCol + c;
                        VariableBinding vb = response.get(r * cols + c);
                        if (vb.isException() || !(id = vb.getOid()).startsWith(col = this.columnOIDs[pos])) continue;
                        OID index = new OID(id.getValue(), col.size(), id.size() - col.size());
                        if (this.upperBoundIndex != null && index.compareTo(this.upperBoundIndex) > 0) continue;
                        if (lastMinIndex == null || index.compareTo(lastMinIndex) < 0) {
                            lastMinIndex = index;
                        }
                        if (row == null) {
                            row = new Row(index);
                            ++this.rowsRetrieved;
                        }
                        row.setNumComplete(pos);
                        if (pos < row.getNumComplete()) {
                            row.set(pos, vb);
                        } else {
                            row.add(vb);
                        }
                        this.lastReceived.set(pos, vb.getOid());
                    }
                    if (row == null || this.listener.next(new TableEvent(this, this.userObject, row.getRowIndex(), row.toArray(new VariableBinding[0])))) continue;
                    this.finished = true;
                    this.listener.finished(new TableEvent(this, this.userObject));
                    return;
                }
                if (!this.sendNextChunk()) {
                    this.finished = true;
                    this.listener.finished(new TableEvent(this, this.userObject));
                }
            }
        }
    }

    protected class ColumnsOfRequest {
        private final List<Integer> columnIDs;
        private final int requestSerial;
        private final LastReceived lastReceived;

        public ColumnsOfRequest(List<Integer> columnIDs, int requestSerial, LastReceived lastReceived) {
            this.columnIDs = columnIDs;
            this.requestSerial = requestSerial;
            this.lastReceived = lastReceived;
        }

        public List<Integer> getColumnIDs() {
            return this.columnIDs;
        }

        public int getRequestSerial() {
            return this.requestSerial;
        }

        public LastReceived getLastReceived() {
            return this.lastReceived;
        }
    }
}

