/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Optional;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.psych.PsychLibrary;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.DumpSettingsBuilder;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.api.YamlOutputStreamWriter;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.common.SpecVersion;
import org.snakeyaml.engine.v2.emitter.Emitter;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.exceptions.EmitterException;
import org.snakeyaml.engine.v2.exceptions.Mark;

public class PsychEmitter
extends RubyObject {
    Emitter emitter;
    StreamDataWriter writer;
    final DumpSettingsBuilder dumpSettingsBuilder = DumpSettings.builder();
    IRubyObject io;
    private static final Optional<Mark> NULL_MARK = Optional.empty();
    private static final StreamStartEvent NULL_STREAM_START_EVENT = new StreamStartEvent(NULL_MARK, NULL_MARK);
    private static final ScalarStyle[] SCALAR_STYLES = new ScalarStyle[]{ScalarStyle.PLAIN, ScalarStyle.PLAIN, ScalarStyle.SINGLE_QUOTED, ScalarStyle.DOUBLE_QUOTED, ScalarStyle.LITERAL, ScalarStyle.FOLDED};
    private static final FlowStyle[] FLOW_STYLES = new FlowStyle[]{FlowStyle.AUTO, FlowStyle.BLOCK, FlowStyle.FLOW};

    public static void initPsychEmitter(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = ruby.defineClassUnder("Handler", ruby.getObject(), ruby.getObject().getAllocator(), rubyModule);
        RubyClass rubyClass2 = ruby.defineClassUnder("Emitter", rubyClass, PsychEmitter::new, rubyModule);
        rubyClass2.defineAnnotatedMethods(PsychEmitter.class);
    }

    public PsychEmitter(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.dumpSettingsBuilder.setIndent(2);
        this.io = iRubyObject;
        return threadContext.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject2.callMethod(threadContext, "line_width");
        IRubyObject iRubyObject4 = iRubyObject2.callMethod(threadContext, "canonical");
        IRubyObject iRubyObject5 = iRubyObject2.callMethod(threadContext, "indentation");
        this.dumpSettingsBuilder.setCanonical(iRubyObject4.isTrue());
        this.dumpSettingsBuilder.setIndent((int)iRubyObject5.convertToInteger().getLongValue());
        this.line_width_set(threadContext, iRubyObject3);
        this.io = iRubyObject;
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject start_stream(ThreadContext threadContext, IRubyObject iRubyObject) {
        TypeConverter.checkType((ThreadContext)threadContext, (IRubyObject)iRubyObject, (RubyModule)threadContext.runtime.getFixnum());
        this.initEmitter(threadContext, iRubyObject);
        this.emit(threadContext, (Event)NULL_STREAM_START_EVENT);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_stream(ThreadContext threadContext) {
        this.emit(threadContext, (Event)NULL_STREAM_START_EVENT);
        return this;
    }

    @JRubyMethod
    public IRubyObject start_document(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Optional<Object> optional;
        Ruby ruby = threadContext.runtime;
        boolean bl = iRubyObject3.isTrue();
        RubyClass rubyClass = ruby.getArray();
        TypeConverter.checkType((ThreadContext)threadContext, (IRubyObject)iRubyObject, (RubyModule)rubyClass);
        RubyArray rubyArray = iRubyObject.convertToArray();
        if (rubyArray.size() == 2) {
            int n = rubyArray.eltInternal(0).convertToInteger().getIntValue();
            int n2 = rubyArray.eltInternal(1).convertToInteger().getIntValue();
            if (n != 1) {
                throw ruby.newArgumentError("invalid YAML version: " + rubyArray);
            }
            optional = Optional.of(new SpecVersion(n, n2));
        } else {
            optional = Optional.empty();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!iRubyObject2.isNil()) {
            TypeConverter.checkType((ThreadContext)threadContext, (IRubyObject)iRubyObject2, (RubyModule)rubyClass);
            RubyArray rubyArray2 = iRubyObject2.convertToArray();
            if (rubyArray2.size() > 0) {
                hashMap = new HashMap(rubyArray2.size());
                for (int i = 0; i < rubyArray2.size(); ++i) {
                    RubyArray rubyArray3 = rubyArray2.eltInternal(i).convertToArray();
                    if (rubyArray3.size() != 2) {
                        throw ruby.newRuntimeError("tags tuple must be of length 2");
                    }
                    IRubyObject iRubyObject4 = rubyArray3.eltInternal(0);
                    IRubyObject iRubyObject5 = rubyArray3.eltInternal(1);
                    hashMap.put(iRubyObject4.asJavaString(), iRubyObject5.asJavaString());
                }
            }
        }
        DocumentStartEvent documentStartEvent = new DocumentStartEvent(!bl, optional, hashMap, NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)documentStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_document(ThreadContext threadContext, IRubyObject iRubyObject) {
        DocumentEndEvent documentEndEvent = new DocumentEndEvent(!iRubyObject.isTrue(), NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)documentEndEvent);
        return this;
    }

    @JRubyMethod(required=6)
    public IRubyObject scalar(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        IRubyObject iRubyObject5 = iRubyObjectArray[4];
        IRubyObject iRubyObject6 = iRubyObjectArray[5];
        RubyClass rubyClass = threadContext.runtime.getString();
        TypeConverter.checkType((ThreadContext)threadContext, (IRubyObject)iRubyObject, (RubyModule)rubyClass);
        RubyString rubyString = (RubyString)iRubyObject;
        rubyString = EncodingUtils.strConvEnc((ThreadContext)threadContext, (RubyString)rubyString, (Encoding)rubyString.getEncoding(), (Encoding)UTF8Encoding.INSTANCE);
        String string = this.exportToUTF8(threadContext, iRubyObject2, rubyClass);
        String string2 = this.exportToUTF8(threadContext, iRubyObject3, rubyClass);
        ScalarEvent scalarEvent = new ScalarEvent(Optional.ofNullable(string == null ? null : new Anchor(string)), Optional.ofNullable(string2), new ImplicitTuple(iRubyObject4.isTrue(), iRubyObject5.isTrue()), rubyString.asJavaString(), SCALAR_STYLES[iRubyObject6.convertToInteger().getIntValue()], NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)scalarEvent);
        return this;
    }

    @JRubyMethod(required=4)
    public IRubyObject start_sequence(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        RubyClass rubyClass = threadContext.runtime.getString();
        String string = this.exportToUTF8(threadContext, iRubyObject, rubyClass);
        String string2 = this.exportToUTF8(threadContext, iRubyObject2, rubyClass);
        SequenceStartEvent sequenceStartEvent = new SequenceStartEvent(Optional.ofNullable(string == null ? null : new Anchor(string)), Optional.ofNullable(string2), iRubyObject3.isTrue(), FLOW_STYLES[iRubyObject4.convertToInteger().getIntValue()], NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)sequenceStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_sequence(ThreadContext threadContext) {
        SequenceEndEvent sequenceEndEvent = new SequenceEndEvent(NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)sequenceEndEvent);
        return this;
    }

    @JRubyMethod(required=4)
    public IRubyObject start_mapping(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        RubyClass rubyClass = threadContext.runtime.getString();
        String string = this.exportToUTF8(threadContext, iRubyObject, rubyClass);
        String string2 = this.exportToUTF8(threadContext, iRubyObject2, rubyClass);
        MappingStartEvent mappingStartEvent = new MappingStartEvent(Optional.ofNullable(string == null ? null : new Anchor(string)), Optional.ofNullable(string2), iRubyObject3.isTrue(), FLOW_STYLES[iRubyObject4.convertToInteger().getIntValue()], NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)mappingStartEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_mapping(ThreadContext threadContext) {
        MappingEndEvent mappingEndEvent = new MappingEndEvent(NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)mappingEndEvent);
        return this;
    }

    @JRubyMethod
    public IRubyObject alias(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyClass rubyClass = threadContext.runtime.getString();
        String string = this.exportToUTF8(threadContext, iRubyObject, rubyClass);
        AliasEvent aliasEvent = new AliasEvent(Optional.of(new Anchor(string)), NULL_MARK, NULL_MARK);
        this.emit(threadContext, (Event)aliasEvent);
        return this;
    }

    @JRubyMethod(name={"canonical="})
    public IRubyObject canonical_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.dumpSettingsBuilder.setCanonical(iRubyObject.isTrue());
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject canonical(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.buildDumpSettings().isCanonical());
    }

    @JRubyMethod(name={"indentation="})
    public IRubyObject indentation_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.dumpSettingsBuilder.setIndent(iRubyObject.convertToInteger().getIntValue());
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject indentation(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.buildDumpSettings().getIndent());
    }

    @JRubyMethod(name={"line_width="})
    public IRubyObject line_width_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = iRubyObject.convertToInteger().getIntValue();
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        }
        this.dumpSettingsBuilder.setWidth(n);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject line_width(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.buildDumpSettings().getWidth());
    }

    private void emit(ThreadContext threadContext, Event event) {
        try {
            if (this.emitter == null) {
                throw threadContext.runtime.newRuntimeError("uninitialized emitter");
            }
            this.emitter.emit(event);
            this.writer.flush();
        }
        catch (EmitterException emitterException) {
            throw threadContext.runtime.newRuntimeError(emitterException.toString());
        }
    }

    private void initEmitter(final ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.emitter != null) {
            throw threadContext.runtime.newRuntimeError("already initialized emitter");
        }
        Encoding encoding = PsychLibrary.YAMLEncoding.values()[(int)iRubyObject.convertToInteger().getLongValue()].encoding;
        Charset charset = threadContext.runtime.getEncodingService().charsetForEncoding(encoding);
        this.writer = new YamlOutputStreamWriter(this, (OutputStream)new IOOutputStream(this.io, encoding), charset){
            final /* synthetic */ PsychEmitter this$0;
            {
                this.this$0 = psychEmitter;
                super(outputStream, charset);
            }

            public void processIOException(IOException iOException) {
                throw threadContext.runtime.newIOErrorFromException(iOException);
            }
        };
        this.emitter = new Emitter(this.buildDumpSettings(), this.writer);
    }

    private DumpSettings buildDumpSettings() {
        return this.dumpSettingsBuilder.build();
    }

    private String exportToUTF8(ThreadContext threadContext, IRubyObject iRubyObject, RubyClass rubyClass) {
        if (iRubyObject.isNil()) {
            return null;
        }
        TypeConverter.checkType((ThreadContext)threadContext, (IRubyObject)iRubyObject, (RubyModule)rubyClass);
        RubyString rubyString = (RubyString)iRubyObject;
        ByteList byteList = rubyString.getByteList();
        return RubyEncoding.decodeUTF8((byte[])byteList.unsafeBytes(), (int)byteList.begin(), (int)byteList.realSize());
    }
}

