/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Collections;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseWhenStaticContext
extends AbstractStaticContext
implements XSLTStaticContext,
Container {
    private NamespaceResolver namespaceContext;
    private FunctionLibrary functionLibrary;
    private Compilation compilation;
    private PackageData packageData;

    public UseWhenStaticContext(Compilation compilation, NamespaceResolver namespaceContext) {
        Configuration config = compilation.getConfiguration();
        this.setConfiguration(config);
        this.compilation = compilation;
        this.packageData = compilation.getPackageData();
        this.namespaceContext = namespaceContext;
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(5));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        lib.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(lib);
        this.functionLibrary = lib;
    }

    public Compilation getCompilation() {
        return this.compilation;
    }

    @Override
    public PackageData getPackageData() {
        return this.packageData;
    }

    @Override
    public void issueWarning(String s, SourceLocator locator) {
        XPathException err = new XPathException(s);
        err.setLocator(locator);
        this.getConfiguration().getErrorListener().warning(err);
    }

    @Override
    public String getSystemId() {
        return this.getBaseURI();
    }

    @Override
    public int getContainerGranularity() {
        return 1;
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.namespaceContext.getURIForPrefix(prefix, false);
        if (uri == null) {
            XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
            err.setErrorCode("XTDE0290");
            throw err;
        }
        return uri;
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        GroundedValue val = this.compilation.getStaticVariable(qName);
        if (val != null) {
            return Literal.makeLiteral(val, this);
        }
        XPathException err = new XPathException("Variables (other than XSLT 3.0 static variables) cannot be used in a static expression: " + qName.getDisplayName());
        err.setErrorCode("XPST0008");
        err.setIsStaticError(true);
        throw err;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public String getDefaultCollationName() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return false;
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        Configuration config = this.getConfiguration();
        if (type.getFingerprint() == 565) {
            return config.getXsdVersion() == 11;
        }
        return this.isSchemaAware() || type.isAllowedInBasicXSLT();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceContext;
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return null;
    }

    @Override
    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = NameChecker.getQNameParts(qname);
            String uri = parts[0].length() == 0 ? this.getDefaultElementNamespace() : this.getURIForPrefix(parts[0]);
            StyleNodeFactory factory = this.getConfiguration().makeStyleNodeFactory(this.compilation);
            return factory.isElementAvailable(uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }
}

