/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Properties;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;

public class SerializationParamsHandler {
    public static final String NAMESPACE = "http://www.w3.org/2010/xslt-xquery-serialization";
    Properties properties;
    SourceLocator locator;

    public void setLocator(SourceLocator locator) {
        this.locator = locator;
    }

    public void setSerializationParams(NodeInfo node) throws XPathException {
        NodeInfo child;
        this.properties = new Properties();
        if (node.getNodeKind() == 9) {
            node = Navigator.getOutermostElement((DocumentInfo)node);
        }
        if (node.getNodeKind() != 1) {
            throw new XPathException("Serialization params: node must be a document or element node");
        }
        if (!node.getLocalPart().equals("serialization-parameters")) {
            throw new XPathException("Serialization params: element name must be 'serialization-parameters");
        }
        if (!node.getURI().equals(NAMESPACE)) {
            throw new XPathException("Serialization params: element namespace must be http://www.w3.org/2010/xslt-xquery-serialization");
        }
        AxisIterator kids = node.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((child = kids.next()) != null) {
            String lname = child.getLocalPart();
            String uri = child.getURI();
            if (NAMESPACE.equals(uri)) {
                uri = "";
            }
            if ("".equals(uri) && lname.equals("use-character-maps")) {
                throw new XPathException("The 'use-character-maps' property is not available.", "SEPM0016");
            }
            String value = child.getAttributeValue("", "value");
            if (value == null) {
                XPathException err = new XPathException("In the serialization parameters, element " + Err.depict(child) + " has no @value attribute", "SEPM0017");
                err.setLocator(this.locator);
                throw err;
            }
            try {
                ResultDocument.setSerializationProperty(this.properties, uri, lname, value, new InscopeNamespaceResolver(child), false, node.getConfiguration());
            }
            catch (XPathException err) {
                if ("XQST0109".equals(err.getErrorCodeLocalPart())) {
                    if (!"".equals(uri)) continue;
                    XPathException e2 = new XPathException("Unknown serialization parameters " + Err.depict(child), "SEPM0017");
                    e2.setLocator(this.locator);
                    throw e2;
                }
                throw err;
            }
        }
    }

    public Properties getSerializationProperties() {
        return this.properties;
    }
}

