/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public class DirStorageFactory
extends BaseStorageFactory
implements WritableStorageFactory {
    @Override
    public final StorageFile newStorageFile(String path) {
        return this.newPersistentFile(path);
    }

    @Override
    public final StorageFile newStorageFile(String directoryName, String fileName) {
        return this.newPersistentFile(directoryName, fileName);
    }

    @Override
    public final StorageFile newStorageFile(StorageFile directoryName, String fileName) {
        return this.newPersistentFile(directoryName, fileName);
    }

    @Override
    StorageFile newPersistentFile(String path) {
        if (path == null) {
            return new DirFile(this.dataDirectory);
        }
        return new DirFile(this.dataDirectory, path);
    }

    @Override
    StorageFile newPersistentFile(String directoryName, String fileName) {
        return new DirFile(this.separatedDataDirectory + directoryName, fileName);
    }

    @Override
    StorageFile newPersistentFile(StorageFile directoryName, String fileName) {
        return new DirFile((DirFile)directoryName, fileName);
    }

    @Override
    public void sync(OutputStream stream, boolean metaData) throws IOException, SyncFailedException {
        ((FileOutputStream)stream).getFD().sync();
    }

    @Override
    public boolean supportsWriteSync() {
        return true;
    }

    @Override
    public boolean isReadOnlyDatabase() {
        return false;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    void doInit() throws IOException {
        if (this.dataDirectory != null) {
            File dataDirectoryFile = new File(this.dataDirectory);
            File databaseRoot = null;
            if (dataDirectoryFile.isAbsolute()) {
                databaseRoot = dataDirectoryFile;
            } else if (this.home != null && this.dataDirectory.startsWith(this.home)) {
                databaseRoot = dataDirectoryFile;
            } else {
                databaseRoot = new File(this.home, this.dataDirectory);
                if (this.home != null) {
                    this.dataDirectory = this.home + this.getSeparator() + this.dataDirectory;
                }
            }
            this.canonicalName = databaseRoot.getCanonicalPath();
            this.createTempDir();
            this.separatedDataDirectory = this.dataDirectory + this.getSeparator();
        } else if (this.home != null) {
            File root = new File(this.home);
            this.dataDirectory = root.getCanonicalPath();
            this.separatedDataDirectory = this.dataDirectory + this.getSeparator();
        }
    }
}

