/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class JavaValueNode
extends QueryTreeNode {
    private boolean mustCastToPrimitive;
    protected boolean forCallStatement;
    private boolean valueReturnedToSQLDomain;
    private boolean returnValueDiscarded;
    protected JSQLType jsqlType;
    private LocalField receiverField;
    private int collationType;

    JavaValueNode(ContextManager cm) {
        super(cm);
    }

    DataTypeDescriptor getDataType() throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(this.getJavaTypeName());
    }

    final boolean isPrimitiveType() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return false;
        }
        return myType.getCategory() == 2;
    }

    String getJavaTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 1: {
                return myType.getJavaClassName();
            }
            case 2: {
                return JSQLType.getPrimitiveName(myType.getPrimitiveKind());
            }
        }
        SanityManager.THROWASSERT((String)("Inappropriate JSQLType: " + String.valueOf(myType)));
        return "";
    }

    final void setJavaTypeName(String javaTypeName) {
        this.jsqlType = new JSQLType(javaTypeName);
    }

    String getPrimitiveTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 2: {
                return JSQLType.getPrimitiveName(myType.getPrimitiveKind());
            }
        }
        SanityManager.THROWASSERT((String)("Inappropriate JSQLType: " + String.valueOf(myType)));
        return "";
    }

    final void castToPrimitive(boolean booleanValue) {
        this.mustCastToPrimitive = booleanValue;
    }

    final boolean mustCastToPrimitive() {
        return this.mustCastToPrimitive;
    }

    JSQLType getJSQLType() throws StandardException {
        return this.jsqlType;
    }

    static TypeId mapToTypeID(JSQLType jsqlType) throws StandardException {
        DataTypeDescriptor dts = jsqlType.getSQLType();
        if (dts == null) {
            return null;
        }
        return dts.getTypeId();
    }

    final void markForCallStatement() {
        this.forCallStatement = true;
    }

    abstract JavaValueNode remapColumnReferencesToExpressions() throws StandardException;

    abstract boolean categorize(JBitSet var1, boolean var2) throws StandardException;

    abstract JavaValueNode bindExpression(FromList var1, SubqueryList var2, List<AggregateNode> var3) throws StandardException;

    abstract void preprocess(int var1, FromList var2, SubqueryList var3, PredicateList var4) throws StandardException;

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateExpression(acb, mb);
    }

    boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        return false;
    }

    int getOrderableVariantType() throws StandardException {
        return 0;
    }

    abstract void generateExpression(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    final boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb, JavaValueNode receiver) throws StandardException {
        if (!this.valueReturnedToSQLDomain() && ClassInspector.primitiveType(this.getJavaTypeName())) {
            return false;
        }
        String receiverClassName = receiver.getJavaTypeName();
        this.receiverField = acb.newFieldDeclaration(2, receiverClassName);
        receiver.generateExpression(acb, mb);
        mb.putField(this.receiverField);
        return true;
    }

    final void getReceiverExpression(ExpressionClassBuilder acb, MethodBuilder mb, JavaValueNode receiver) throws StandardException {
        if (this.receiverField != null) {
            mb.getField(this.receiverField);
        } else {
            receiver.generateExpression(acb, mb);
        }
    }

    void returnValueToSQLDomain() {
        this.valueReturnedToSQLDomain = true;
    }

    boolean valueReturnedToSQLDomain() {
        return this.valueReturnedToSQLDomain;
    }

    void markReturnValueDiscarded() {
        this.returnValueDiscarded = true;
    }

    boolean returnValueDiscarded() {
        return this.returnValueDiscarded;
    }

    void checkReliability(ValueNode sqlNode) throws StandardException {
        sqlNode.checkReliability(4, "42Z00.U");
    }

    int getCollationType() {
        return this.collationType;
    }

    void setCollationType(int type) {
        this.collationType = type;
    }
}

