/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EmbedStatement
extends ConnectionChild
implements EngineStatement {
    private final Connection applicationConnection;
    protected EngineStatement applicationStatement;
    long updateCount = -1L;
    EmbedResultSet results;
    private java.sql.ResultSet autoGeneratedKeysResultSet;
    private String cursorName;
    private final boolean forMetaData;
    final int resultSetType;
    final int resultSetConcurrency;
    private final int resultSetHoldability;
    final LanguageConnectionContext lcc;
    private SQLWarning warnings;
    String SQLText;
    private int fetchSize = 1;
    private int fetchDirection = 1000;
    int MaxFieldSize;
    long timeoutMillis;
    private boolean active = true;
    Vector<Object> batchStatements;
    long maxRows;
    private ParameterValueSet pvs;
    protected boolean isPoolable = false;
    private boolean closeOnCompletion = false;
    private boolean closingResultSets = false;
    private EmbedResultSet[] dynamicResults;
    private int currentDynamicResultSet;

    public EmbedStatement(EmbedConnection connection, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection);
        this.forMetaData = forMetaData;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.lcc = this.getLanguageConnectionContext(this.getEmbedConnection());
        this.applicationConnection = this.getEmbedConnection().getApplicationConnection();
        this.applicationStatement = this;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql, true, false, 2, null, null);
        if (this.results == null) {
            SanityManager.THROWASSERT((String)"no results returned on executeQuery()");
        }
        return this.results;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.execute(sql, false, true, 2, null, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (int)this.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.execute(sql, false, true, autoGeneratedKeys, null, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.execute(sql, false, true, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.execute(sql, false, true, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
        return this.updateCount;
    }

    final void checkIfInMiddleOfBatch() throws SQLException {
        if (this.batchStatements != null) {
            throw EmbedStatement.newSQLException("XJ068.S", new Object[0]);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.active) {
            try {
                this.checkExecStatus();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return !this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.closeActions();
            this.active = false;
            this.clearResultSets();
            this.cursorName = null;
            this.warnings = null;
            this.SQLText = null;
            this.batchStatements = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.results != null && this.results.singleUseActivation != null) {
            this.results.singleUseActivation.markUnused();
        }
    }

    void closeActions() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkStatus();
        return this.MaxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatus();
        if (max < 0) {
            throw EmbedStatement.newSQLException("XJ066.S", max);
        }
        this.MaxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkStatus();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkStatus();
        if (max < 0L) {
            throw EmbedStatement.newSQLException("XJ063.S", max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatus();
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        this.checkStatus();
        return (int)(this.timeoutMillis / 1000L);
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatus();
        if (seconds < 0) {
            throw EmbedStatement.newSQLException("XJ074.S", seconds);
        }
        this.timeoutMillis = (long)seconds * 1000L;
    }

    @Override
    public void cancel() throws SQLException {
        throw Util.notImplemented("cancel");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatus();
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkStatus();
        this.cursorName = name;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, false, false, 2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(String sql, boolean executeQuery, boolean executeUpdate, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.checkExecStatus();
            if (sql == null) {
                throw EmbedStatement.newSQLException("XJ067.S", new Object[0]);
            }
            this.checkIfInMiddleOfBatch();
            this.clearResultSets();
            this.setupContextStack();
            this.SQLText = sql;
            try {
                Activation activation;
                try {
                    PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), sql, this.resultSetConcurrency == 1007, false);
                    activation = preparedStatement.getActivation(this.lcc, this.resultSetType == 1004);
                    this.checkRequiresCallableStatement(activation);
                    InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
                }
                catch (Throwable t) {
                    throw this.handleException(t);
                }
                activation.setSingleExecution();
                if (autoGeneratedKeys == 1) {
                    activation.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
                }
                bl = this.executeStatement(activation, executeQuery, executeUpdate);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql, false, false, autoGeneratedKeys, null, null);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, false, true, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, false, true, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
    }

    @Override
    public final java.sql.ResultSet getResultSet() throws SQLException {
        this.checkStatus();
        return this.results;
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        this.checkStatus();
        return (int)this.updateCount;
    }

    @Override
    public final long getLargeUpdateCount() throws SQLException {
        this.checkStatus();
        return this.updateCount;
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public final int getResultSetType() throws SQLException {
        this.checkStatus();
        return this.resultSetType;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatus();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw EmbedStatement.newSQLException("XJ064.S", direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkStatus();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkStatus();
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            throw EmbedStatement.newSQLException("XJ065.S", rows);
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkStatus();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus();
        return this.resultSetConcurrency;
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        this.checkStatus();
        return this.resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.add(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return Util.squashLongs(this.executeLargeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            SQLException sqle;
            int i;
            this.setupContextStack();
            this.clearResultSets();
            Vector<Object> stmts = this.batchStatements;
            this.batchStatements = null;
            int size = stmts == null ? 0 : stmts.size();
            long[] returnUpdateCountForBatch = new long[size];
            try {
                for (i = 0; i < size; ++i) {
                    InterruptStatus.throwIf(this.lcc);
                    if (this.executeBatchElement(stmts.get(i))) {
                        throw EmbedStatement.newSQLException("XJ04B.S", new Object[0]);
                    }
                    returnUpdateCountForBatch[i] = this.getLargeUpdateCount();
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
                long[] lArray = returnUpdateCountForBatch;
                return lArray;
            }
            catch (StandardException se) {
                sqle = this.handleException(se);
            }
            catch (SQLException sqle2) {
                sqle = sqle2;
            }
            finally {
                this.restoreContextStack();
            }
            long[] successfulUpdateCount = Arrays.copyOf(returnUpdateCountForBatch, i);
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), successfulUpdateCount, (Throwable)sqle);
        }
    }

    boolean executeBatchElement(Object batchElement) throws SQLException, StandardException {
        return this.execute((String)batchElement, false, true, 2, null, null);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        this.checkStatus();
        Connection appConn = this.getEmbedConnection().getApplicationConnection();
        if (appConn != this.applicationConnection || appConn == null) {
            throw Util.noCurrentConnection();
        }
        return appConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.dynamicResults == null) {
                this.clearResultSets();
                this.closeMeOnCompletion();
                return false;
            }
            switch (current) {
                default: {
                    int startingClose = 0;
                    break;
                }
                case 1: {
                    int startingClose = this.currentDynamicResultSet;
                    break;
                }
                case 2: {
                    int startingClose = this.dynamicResults.length;
                }
            }
            SQLException se = null;
            for (int i = startingClose; i <= this.currentDynamicResultSet && i < this.dynamicResults.length; ++i) {
                EmbedResultSet lrs = this.dynamicResults[i];
                if (lrs == null) continue;
                try {
                    lrs.close();
                    continue;
                }
                catch (SQLException sqle) {
                    if (se == null) {
                        se = sqle;
                        continue;
                    }
                    se.setNextException(sqle);
                    continue;
                }
                finally {
                    this.dynamicResults[i] = null;
                }
            }
            if (se != null) {
                throw se;
            }
            this.updateCount = -1L;
            while (++this.currentDynamicResultSet < this.dynamicResults.length) {
                EmbedResultSet lrs = this.dynamicResults[this.currentDynamicResultSet];
                if (lrs == null) continue;
                if (lrs.isClosed) {
                    this.dynamicResults[this.currentDynamicResultSet] = null;
                    continue;
                }
                this.results = lrs;
                return true;
            }
            this.results = null;
            return false;
        }
    }

    @Override
    public final java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.checkStatus();
        if (this.autoGeneratedKeysResultSet == null) {
            return null;
        }
        this.execute("VALUES IDENTITY_VAL_LOCAL()", true, false, 2, null, null);
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean retval;
            SanityManager.ASSERT((this.results == null ? 1 : 0) != 0);
            SanityManager.ASSERT((this.dynamicResults == null ? 1 : 0) != 0);
            SanityManager.ASSERT((this.autoGeneratedKeysResultSet == null ? 1 : 0) != 0);
            this.setupContextStack();
            this.pvs = a.getParameterValueSet();
            try {
                this.clearWarnings();
                if (!this.forMetaData) {
                    this.commitIfNeeded();
                    this.needCommit();
                } else if (this.lcc.getActivationCount() <= 1) {
                    this.commitIfNeeded();
                    this.needCommit();
                }
                ExecPreparedStatement ps = a.getPreparedStatement();
                if (this.cursorName != null) {
                    a.setCursorName(this.cursorName);
                }
                boolean executeHoldable = this.getExecuteHoldable();
                a.setResultSetHoldability(executeHoldable);
                a.reset();
                a.setMaxRows(this.maxRows);
                ResultSet resultsToWrap = ps.execute(a, this.forMetaData, this.timeoutMillis);
                this.addWarning(ps.getCompileTimeWarnings());
                this.addWarning(a.getWarnings());
                if (resultsToWrap.returnsRows()) {
                    EmbedResultSet lresults;
                    if (executeUpdate) {
                        throw StandardException.newException((String)"X0Y79.S", (Object[])new Object[0]);
                    }
                    this.results = lresults = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultsToWrap, this.forMetaData, this, ps.isAtomic());
                    if (a.isSingleExecution()) {
                        lresults.singleUseActivation = a;
                    }
                    this.updateCount = -1L;
                    retval = true;
                } else {
                    if (a.getAutoGeneratedKeysResultsetMode() && resultsToWrap.getAutoGeneratedKeysResultset() != null) {
                        resultsToWrap.getAutoGeneratedKeysResultset().open();
                        this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultsToWrap.getAutoGeneratedKeysResultset(), false, this, ps.isAtomic());
                    }
                    this.updateCount = resultsToWrap.modifiedRowCount();
                    this.results = null;
                    int dynamicResultCount = 0;
                    if (a.getDynamicResults() != null) {
                        dynamicResultCount = this.processDynamicResults(a.getDynamicResults(), a.getMaxDynamicResults());
                    }
                    resultsToWrap.close();
                    if (executeQuery && dynamicResultCount != 1) {
                        throw StandardException.newException((String)"X0Y78.S", (Object[])new Object[0]);
                    }
                    if (executeUpdate && dynamicResultCount > 0) {
                        throw StandardException.newException((String)"X0Y79.S", (Object[])new Object[0]);
                    }
                    if (dynamicResultCount == 0) {
                        if (a.isSingleExecution()) {
                            a.close();
                        }
                        if (!this.forMetaData) {
                            this.commitIfNeeded();
                        } else if (this.lcc.getActivationCount() <= 1) {
                            this.commitIfNeeded();
                        }
                    }
                    retval = dynamicResultCount > 0;
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
            }
            catch (Throwable t) {
                if (a.isSingleExecution()) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            return retval;
        }
    }

    final void addWarning(SQLWarning sw) {
        if (sw != null) {
            if (this.warnings == null) {
                this.warnings = sw;
            } else {
                this.warnings.setNextException(sw);
            }
        }
    }

    public String getSQLText() {
        return this.SQLText;
    }

    public ParameterValueSet getParameterValueSet() {
        return this.pvs;
    }

    final void checkStatus() throws SQLException {
        if (!this.active) {
            Connection appConn = this.getEmbedConnection().getApplicationConnection();
            if (appConn == null || appConn.isClosed()) {
                throw Util.noCurrentConnection();
            }
            throw EmbedStatement.newSQLException("XJ012.S", "Statement");
        }
    }

    final void checkExecStatus() throws SQLException {
        if (!this.getConnection().isClosed()) {
            return;
        }
        this.active = false;
        throw Util.noCurrentConnection();
    }

    void clearResultSets() throws SQLException {
        try {
            this.closingResultSets = true;
            this.clearResultSetsMinion();
        }
        finally {
            this.closingResultSets = false;
        }
    }

    private void clearResultSetsMinion() throws SQLException {
        SQLException sqle = null;
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException s1) {
            sqle = s1;
        }
        try {
            if (this.autoGeneratedKeysResultSet != null) {
                this.autoGeneratedKeysResultSet.close();
                this.autoGeneratedKeysResultSet = null;
            }
        }
        catch (SQLException sauto) {
            if (sqle == null) {
                sqle = sauto;
            }
            sqle.setNextException(sauto);
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet lrs = this.dynamicResults[i];
                if (lrs == null) continue;
                try {
                    lrs.close();
                    continue;
                }
                catch (SQLException sdynamic) {
                    if (sqle == null) {
                        sqle = sdynamic;
                        continue;
                    }
                    sqle.setNextException(sdynamic);
                }
            }
            this.dynamicResults = null;
        }
        this.updateCount = -1L;
        if (sqle != null) {
            throw sqle;
        }
    }

    void checkRequiresCallableStatement(Activation activation) throws SQLException {
        ParameterValueSet pvs = activation.getParameterValueSet();
        if (pvs == null) {
            return;
        }
        if (pvs.checkNoDeclaredOutputParameters()) {
            try {
                activation.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw EmbedStatement.newSQLException("XJ009.S", this.SQLText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferBatch(EmbedStatement other) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            other.batchStatements = this.batchStatements;
            this.batchStatements = null;
        }
    }

    public final void setApplicationStatement(EngineStatement s) {
        this.applicationStatement = s;
    }

    private int processDynamicResults(java.sql.ResultSet[][] holder, int maxDynamicResultSets) throws SQLException {
        int i;
        Object[] sorted = new EmbedResultSet[holder.length];
        int actualCount = 0;
        for (i = 0; i < holder.length; ++i) {
            java.sql.ResultSet[] param = holder[i];
            java.sql.ResultSet rs = param[0];
            param[0] = null;
            EmbedResultSet lrs = EmbedStatement.processDynamicResult(this.getEmbedConnection(), rs, this);
            if (lrs == null) continue;
            sorted[actualCount++] = lrs;
        }
        if (actualCount != 0) {
            if (actualCount != 1) {
                Arrays.sort(sorted, 0, actualCount);
            }
            this.dynamicResults = sorted;
            if (actualCount > maxDynamicResultSets) {
                this.addWarning(StandardException.newWarning((String)"0100E", (Object[])new Object[0]));
                for (i = maxDynamicResultSets; i < actualCount; ++i) {
                    ((EmbedResultSet)sorted[i]).close();
                    sorted[i] = null;
                }
                actualCount = maxDynamicResultSets;
            }
            this.updateCount = -1L;
            this.results = sorted[0];
            this.currentDynamicResultSet = 0;
        }
        return actualCount;
    }

    static EmbedResultSet processDynamicResult(EmbedConnection conn, java.sql.ResultSet resultSet, EmbedStatement callStatement) {
        if (resultSet == null) {
            return null;
        }
        if (!(resultSet instanceof EmbedResultSet)) {
            return null;
        }
        EmbedResultSet lrs = (EmbedResultSet)resultSet;
        if (lrs.getEmbedConnection().rootConnection != conn.rootConnection) {
            return null;
        }
        try {
            lrs.checkIfClosed("");
        }
        catch (SQLException ex) {
            return null;
        }
        lrs.setDynamicResultSet(callStatement);
        return lrs;
    }

    void resultSetClosing(EmbedResultSet closingLRS) throws SQLException {
        if (!this.getEmbedConnection().autoCommit) {
            return;
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet lrs = this.dynamicResults[i];
                if (lrs == null || lrs.isClosed || lrs == closingLRS) continue;
                return;
            }
        }
        this.commitIfAutoCommit();
    }

    private boolean getExecuteHoldable() throws SQLException {
        if (this.resultSetHoldability == 2) {
            return false;
        }
        if (this.applicationStatement == this) {
            return true;
        }
        return this.applicationStatement.getResultSetHoldability() == 1;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatus();
        return this.isPoolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkStatus();
        this.isPoolable = poolable;
    }

    @Override
    public final boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        this.checkStatus();
        return interfaces.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> interfaces) throws SQLException {
        this.checkStatus();
        try {
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw EmbedStatement.newSQLException("XJ128.S", interfaces);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkStatus();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkStatus();
        return this.closeOnCompletion;
    }

    void closeMeOnCompletion() {
        if (this.active && !this.closingResultSets && this.closeOnCompletion) {
            try {
                if (this.isOpen(this.results)) {
                    return;
                }
                if (this.autoGeneratedKeysResultSet != null) {
                    return;
                }
                if (this.dynamicResults != null) {
                    int count = this.dynamicResults.length;
                    for (int i = 0; i < count; ++i) {
                        if (!this.isOpen(this.dynamicResults[i])) continue;
                        return;
                    }
                }
                this.close();
            }
            catch (SQLException se) {
                Util.logSQLException(se);
            }
        }
    }

    private boolean isOpen(EmbedResultSet rs) throws SQLException {
        return rs != null && !rs.isClosed();
    }
}

