/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLDecimal
extends NumberDataType
implements VariableSizeDataValue {
    private BigDecimal value;
    private byte[] rawData;
    private int rawScale;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDecimal.class);
    private static final int BIG_DECIMAL_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(BigDecimal.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += BIG_DECIMAL_MEMORY_USAGE + (this.value.unscaledValue().bitLength() + 8) / 8;
        }
        if (null != this.rawData) {
            sz += this.rawData.length;
        }
        return sz;
    }

    public SQLDecimal() {
    }

    public SQLDecimal(BigDecimal val) {
        this.value = val;
    }

    public SQLDecimal(BigDecimal val, int nprecision, int scale) throws StandardException {
        this.value = val;
        if (this.value != null && scale >= 0) {
            this.value = this.value.setScale(scale, RoundingMode.DOWN);
        }
    }

    public SQLDecimal(String val) {
        this.value = new BigDecimal(val);
    }

    @Override
    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException((String)"22003", (Object[])new Object[]{"INTEGER"});
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -128L && lv <= 127L) {
                return (byte)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException((String)"22003", (Object[])new Object[]{"TINYINT"});
    }

    @Override
    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -32768L && lv <= 32767L) {
                return (short)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException((String)"22003", (Object[])new Object[]{"SMALLINT"});
    }

    @Override
    public long getLong() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0L;
        }
        if (localValue.compareTo(MINLONG_MINUS_ONE) == 1 && localValue.compareTo(MAXLONG_PLUS_ONE) == -1) {
            return localValue.longValue();
        }
        throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
    }

    @Override
    public float getFloat() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0.0f;
        }
        float value = NumberDataType.normalizeREAL(localValue.floatValue());
        return value;
    }

    @Override
    public double getDouble() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0.0;
        }
        double value = NumberDataType.normalizeDOUBLE(localValue.doubleValue());
        return value;
    }

    private BigDecimal getBigDecimal() {
        if (this.value == null && this.rawData != null) {
            this.value = new BigDecimal(new BigInteger(this.rawData), this.rawScale);
        }
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 3;
    }

    @Override
    public boolean getBoolean() {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return false;
        }
        return localValue.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public String getString() {
        BigDecimal localValue = this.getBigDecimal();
        return localValue == null ? null : localValue.toPlainString();
    }

    @Override
    public Object getObject() {
        return this.getBigDecimal();
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((BigDecimal)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setCoreValue(SQLDecimal.getBigDecimal(theValue));
    }

    @Override
    public int getLength() {
        return this.getDecimalValuePrecision();
    }

    @Override
    public String getTypeName() {
        return "DECIMAL";
    }

    @Override
    public int getTypeFormatId() {
        return 200;
    }

    @Override
    public boolean isNull() {
        return this.value == null && this.rawData == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] byteArray;
        int scale;
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        if (this.value != null) {
            scale = this.value.scale();
            if (scale < 0) {
                scale = 0;
                this.value = this.value.setScale(0);
            }
            BigInteger bi = this.value.unscaledValue();
            byteArray = bi.toByteArray();
        } else {
            scale = this.rawScale;
            byteArray = this.rawData;
        }
        if (scale < 0) {
            SanityManager.THROWASSERT((String)("DECIMAL scale at writeExternal is negative " + scale + " value " + this.toString()));
        }
        out.writeByte(scale);
        out.writeByte(byteArray.length);
        out.write(byteArray);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = null;
        this.rawScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.rawData == null || size != this.rawData.length) {
            this.rawData = new byte[size];
        }
        in.readFully(this.rawData);
    }

    @Override
    public void restoreToNull() {
        this.value = null;
        this.rawData = null;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        BigDecimal otherValue = SQLDecimal.getBigDecimal(arg);
        return this.getBigDecimal().compareTo(otherValue);
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLDecimal(this.getBigDecimal());
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDecimal();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getBigDecimal(colNumber);
        this.rawData = null;
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 3);
            return;
        }
        ps.setBigDecimal(position, this.getBigDecimal());
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.rawData = null;
        if (theValue == null) {
            this.value = null;
        } else {
            try {
                theValue = theValue.trim();
                this.value = new BigDecimal(theValue);
                this.rawData = null;
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
        }
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(theValue));
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(theValue));
    }

    @Override
    public void setValue(long theValue) {
        this.value = BigDecimal.valueOf(theValue);
        this.rawData = null;
    }

    @Override
    public void setValue(int theValue) {
        this.setValue((long)theValue);
    }

    @Override
    public void setBigDecimal(BigDecimal theValue) throws StandardException {
        this.setCoreValue(theValue);
    }

    @Override
    public void setValue(Number theValue) throws StandardException {
        if (theValue != null && !(theValue instanceof BigDecimal) && !(theValue instanceof Long)) {
            SanityManager.THROWASSERT((String)("SQLDecimal.setValue(Number) passed a " + String.valueOf(theValue.getClass())));
        }
        if (theValue instanceof BigDecimal || theValue == null) {
            this.setCoreValue((BigDecimal)theValue);
        } else {
            this.setValue(theValue.longValue());
        }
    }

    @Override
    public void setValue(boolean theValue) {
        this.setCoreValue(theValue ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public int typePrecedence() {
        return 70;
    }

    private void setCoreValue(BigDecimal theValue) {
        this.value = theValue;
        this.rawData = null;
    }

    private void setCoreValue(double theValue) {
        this.value = new BigDecimal(Double.toString(theValue));
        this.rawData = null;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredScale = desiredType.getScale();
        int desiredPrecision = desiredType.getPrecision();
        this.setFrom(source);
        this.setWidth(desiredPrecision, desiredScale, true);
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(addend1).add(SQLDecimal.getBigDecimal(addend2)));
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(left).subtract(SQLDecimal.getBigDecimal(right)));
        return result;
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(left).multiply(SQLDecimal.getBigDecimal(right)));
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        return this.divide(dividend, divisor, result, -1);
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        BigDecimal divisorBigDecimal = SQLDecimal.getBigDecimal(divisor);
        if (divisorBigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            throw StandardException.newException((String)"22012", (Object[])new Object[0]);
        }
        BigDecimal dividendBigDecimal = SQLDecimal.getBigDecimal(dividend);
        result.setBigDecimal(dividendBigDecimal.divide(divisorBigDecimal, scale > -1 ? scale : Math.max(dividendBigDecimal.scale() + SQLDecimal.getWholeDigits(divisorBigDecimal) + 1, 4), RoundingMode.DOWN));
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(this.getBigDecimal().negate());
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.getBigDecimal().compareTo(BigDecimal.ZERO) == -1;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }

    public int hashCode() {
        long longVal;
        double doubleVal;
        BigDecimal localValue = this.getBigDecimal();
        double d = doubleVal = localValue != null ? localValue.doubleValue() : 0.0;
        if (Double.isInfinite(doubleVal)) {
            longVal = localValue.longValue();
        } else {
            longVal = (long)doubleVal;
            if ((double)longVal != doubleVal) {
                longVal = Double.doubleToLongBits(doubleVal);
            }
        }
        return (int)(longVal ^ longVal >> 32);
    }

    @Override
    public void setWidth(int desiredPrecision, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (desiredPrecision != -1 && desiredPrecision - desiredScale < SQLDecimal.getWholeDigits(this.getBigDecimal())) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"DECIMAL/NUMERIC(" + desiredPrecision + "," + desiredScale + ")"});
        }
        this.value = this.value.setScale(desiredScale, RoundingMode.DOWN);
        this.rawData = null;
    }

    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigDecimal localValue = this.getBigDecimal();
        return SQLDecimal.getWholeDigits(localValue) + this.getDecimalValueScale();
    }

    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value == null) {
            return this.rawScale;
        }
        int scale = this.value.scale();
        if (scale >= 0) {
            return scale;
        }
        return 0;
    }

    public static BigDecimal getBigDecimal(DataValueDescriptor value) throws StandardException {
        if (value.isNull()) {
            SanityManager.THROWASSERT((String)"NULL value passed to SQLDecimal.getBigDecimal");
        }
        switch (value.typeToBigDecimal()) {
            case 3: {
                return (BigDecimal)value.getObject();
            }
            case 1: {
                try {
                    return new BigDecimal(value.getString().trim());
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException((String)"22018", (Object[])new Object[]{"java.math.BigDecimal"});
                }
            }
            case -5: {
                return BigDecimal.valueOf(value.getLong());
            }
        }
        SanityManager.THROWASSERT((String)("invalid return from " + String.valueOf(value.getClass()) + ".typeToBigDecimal() " + value.typeToBigDecimal()));
        return null;
    }

    private static int getWholeDigits(BigDecimal decimalValue) {
        if (BigDecimal.ONE.compareTo(decimalValue = decimalValue.abs()) == 1) {
            return 0;
        }
        return decimalValue.precision() - decimalValue.scale();
    }
}

