/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.types.HarmonySerialBlob;

public class HarmonySerialClob
implements Clob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1662519690087375313L;
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;

    public HarmonySerialClob(String raw) {
        this(raw.toCharArray());
    }

    public HarmonySerialClob(char[] ch) {
        this.buf = new char[ch.length];
        this.len = this.origLen = (long)ch.length;
        System.arraycopy(ch, 0, this.buf, 0, (int)this.len);
    }

    public HarmonySerialClob(Clob clob) throws SQLException {
        if (clob == null) {
            throw new IllegalArgumentException();
        }
        Reader characterStream = clob.getCharacterStream();
        if (characterStream == null && clob.getAsciiStream() == null) {
            throw new IllegalArgumentException();
        }
        this.clob = clob;
        this.len = this.origLen = clob.length();
        this.buf = new char[(int)this.len];
        try {
            characterStream.read(this.buf);
        }
        catch (IOException e) {
            SQLException se = new SQLException("SerialClob: " + e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        return this.clob.getAsciiStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkValidation();
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{length});
        }
        if (pos < 1L || pos > this.len || pos + (long)length > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{pos});
        }
        try {
            return new String(this.buf, (int)(pos - 1L), length);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException();
        }
    }

    @Override
    public long position(Clob searchClob, long start) throws SQLException {
        this.checkValidation();
        String searchString = searchClob.getSubString(1L, (int)searchClob.length());
        return this.position(searchString, start);
    }

    @Override
    public long position(String searchString, long start) throws SQLException, SQLException {
        this.checkValidation();
        if (start < 1L || this.len - (start - 1L) < (long)searchString.length()) {
            return -1L;
        }
        char[] pattern = searchString.toCharArray();
        int i = (int)start - 1;
        while ((long)i < this.len) {
            if (this.match(this.buf, i, pattern)) {
                return i + 1;
            }
            ++i;
        }
        return -1L;
    }

    private boolean match(char[] chars, int start, char[] pattern) {
        int i = 0;
        while (i < pattern.length) {
            if (chars[start++] == pattern[i++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        OutputStream os = this.clob.setAsciiStream(pos);
        if (os == null) {
            throw new IllegalStateException();
        }
        return os;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        Writer writer = this.clob.setCharacterStream(pos);
        if (writer == null) {
            throw new IllegalStateException();
        }
        return writer;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.checkValidation();
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int length) throws SQLException {
        this.checkValidation();
        if (pos < 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{pos});
        }
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", null);
        }
        if (pos > this.len - (long)length + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ076.S", null);
        }
        if (offset < 0 || offset > str.length() - length) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        if ((long)length > this.len + (long)offset) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        str.getChars(offset, offset + length, this.buf, (int)pos - 1);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.checkValidation();
        if (length < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{length});
        }
        if (length > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{length});
        }
        char[] truncatedBuffer = new char[(int)length];
        System.arraycopy(this.buf, 0, truncatedBuffer, 0, (int)length);
        this.buf = truncatedBuffer;
        this.len = length;
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.clob = null;
            this.buf = null;
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf, (int)pos, (int)length);
    }

    private void checkValidation() throws SQLException {
        if (this.len == -1L) {
            throw HarmonySerialBlob.makeSQLException("XJ215.S", null);
        }
    }
}

