/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.SqlException;

public class ClientParameterMetaData
implements ParameterMetaData {
    private ColumnMetaData columnMetaData_;

    public ClientParameterMetaData(ColumnMetaData columnMetaData) {
        this.columnMetaData_ = columnMetaData;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.columnMetaData_.columns_;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.columnMetaData_.getColumnType(param);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.columnMetaData_.getColumnTypeName(param);
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.columnMetaData_.getColumnClassName(param);
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        try {
            this.columnMetaData_.checkForValidColumnIndex(param);
            if (this.columnMetaData_.sqlxParmmode_[param - 1] == 0) {
                return 0;
            }
            if (this.columnMetaData_.sqlxParmmode_[param - 1] == 1) {
                return 1;
            }
            if (this.columnMetaData_.sqlxParmmode_[param - 1] == 4) {
                return 4;
            }
            return 2;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.columnMetaData_.isNullable(param);
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.columnMetaData_.isSigned(param);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.columnMetaData_.getPrecision(param);
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.columnMetaData_.getScale(param);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), iface).getSQLException();
        }
    }
}

