/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManagerFactory;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class MiniSSL
extends RubyObject {
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new MiniSSL(ruby, rubyClass);
        }
    };
    private SSLEngine engine;
    private boolean closed;
    private boolean handshake;
    private MiniSSLBuffer inboundNetData;
    private MiniSSLBuffer outboundAppData;
    private MiniSSLBuffer outboundNetData;
    private static Map<String, KeyManagerFactory> keyManagerFactoryMap = new ConcurrentHashMap<String, KeyManagerFactory>();
    private static Map<String, TrustManagerFactory> trustManagerFactoryMap = new ConcurrentHashMap<String, TrustManagerFactory>();

    public static void createMiniSSL(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("MiniSSL");
        rubyModule.defineClassUnder("SSLError", ruby.getClass("IOError"), ruby.getClass("IOError").getAllocator());
        RubyClass rubyClass = rubyModule2.defineClassUnder("Engine", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(MiniSSL.class);
    }

    public MiniSSL(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static synchronized IRubyObject server(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = iRubyObject2.callMethod(threadContext, "keystore").convertToString().asJavaString();
        char[] cArray = iRubyObject2.callMethod(threadContext, "keystore_pass").convertToString().asJavaString().toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            keyStore.load(fileInputStream, cArray);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, cArray);
        keyManagerFactoryMap.put(string, keyManagerFactory);
        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
        fileInputStream = new FileInputStream(string);
        try {
            keyStore2.load(fileInputStream, cArray);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore2);
        trustManagerFactoryMap.put(string, trustManagerFactory);
        RubyClass rubyClass = (RubyClass)iRubyObject;
        return rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        String[] stringArray;
        IRubyObject iRubyObject2;
        String string = iRubyObject.callMethod(threadContext, "keystore").convertToString().asJavaString();
        KeyManagerFactory keyManagerFactory = keyManagerFactoryMap.get(string);
        TrustManagerFactory trustManagerFactory = trustManagerFactoryMap.get(string);
        if (keyManagerFactory == null || trustManagerFactory == null) {
            throw new KeyStoreException("Could not find KeyManagerFactory/TrustManagerFactory for keystore: " + string);
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        this.closed = false;
        this.handshake = false;
        this.engine = sSLContext.createSSLEngine();
        String[] stringArray2 = iRubyObject.callMethod(threadContext, "no_tlsv1").isTrue() ? new String[]{"TLSv1.1", "TLSv1.2"} : new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        if (iRubyObject.callMethod(threadContext, "no_tlsv1_1").isTrue()) {
            stringArray2 = new String[]{"TLSv1.2"};
        }
        this.engine.setEnabledProtocols(stringArray2);
        this.engine.setUseClientMode(false);
        long l = iRubyObject.callMethod(threadContext, "verify_mode").convertToInteger("to_i").getLongValue();
        if ((l & 1L) != 0L) {
            this.engine.setWantClientAuth(true);
        }
        if ((l & 2L) != 0L) {
            this.engine.setNeedClientAuth(true);
        }
        if (!(iRubyObject2 = iRubyObject.callMethod(threadContext, "ssl_cipher_list")).isNil()) {
            stringArray = iRubyObject2.convertToString().asJavaString().split(",");
            this.engine.setEnabledCipherSuites(stringArray);
        }
        stringArray = this.engine.getSession();
        this.inboundNetData = new MiniSSLBuffer(stringArray.getPacketBufferSize());
        this.outboundAppData = new MiniSSLBuffer(stringArray.getApplicationBufferSize());
        this.outboundAppData.flip();
        this.outboundNetData = new MiniSSLBuffer(stringArray.getPacketBufferSize());
        return this;
    }

    @JRubyMethod
    public IRubyObject inject(IRubyObject iRubyObject) {
        ByteList byteList = iRubyObject.convertToString().getByteList();
        this.inboundNetData.put(byteList.unsafeBytes(), byteList.getBegin(), byteList.getRealSize());
        return this;
    }

    private SSLEngineResult doOp(SSLOperation sSLOperation, MiniSSLBuffer miniSSLBuffer, MiniSSLBuffer miniSSLBuffer2) throws SSLException {
        SSLEngineResult sSLEngineResult = null;
        boolean bl = true;
        while (bl) {
            switch (sSLOperation) {
                case WRAP: {
                    sSLEngineResult = this.engine.wrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                case UNWRAP: {
                    sSLEngineResult = this.engine.unwrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SSLOperation: " + (Object)((Object)sSLOperation));
                }
            }
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int n = Math.max(this.engine.getSession().getPacketBufferSize(), this.engine.getSession().getApplicationBufferSize());
                    miniSSLBuffer2.resize(n + miniSSLBuffer2.position());
                    bl = true;
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    bl = false;
                    break;
                }
                case CLOSED: {
                    this.closed = true;
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.handshake = true;
        }
        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this.engine.getDelegatedTask()) != null) {
                runnable.run();
            }
        }
        return sSLEngineResult;
    }

    @JRubyMethod
    public IRubyObject read() {
        try {
            this.inboundNetData.flip();
            if (!this.inboundNetData.hasRemaining()) {
                return this.getRuntime().getNil();
            }
            MiniSSLBuffer miniSSLBuffer = new MiniSSLBuffer(this.engine.getSession().getApplicationBufferSize());
            this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            boolean bl = false;
            SSLEngineResult sSLEngineResult = null;
            while (!bl) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        sSLEngineResult = this.doOp(SSLOperation.WRAP, miniSSLBuffer, this.outboundNetData);
                        break;
                    }
                    case NEED_UNWRAP: {
                        sSLEngineResult = this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
                        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) continue;
                handshakeStatus = sSLEngineResult.getHandshakeStatus();
            }
            if (this.inboundNetData.hasRemaining()) {
                this.inboundNetData.compact();
            } else {
                this.inboundNetData.clear();
            }
            ByteList byteList = miniSSLBuffer.asByteList();
            if (byteList == null) {
                return this.getRuntime().getNil();
            }
            return RubyString.newString((Ruby)this.getRuntime(), (ByteList)byteList);
        }
        catch (SSLException sSLException) {
            RaiseException raiseException = this.getRuntime().newEOFError(sSLException.getMessage());
            raiseException.initCause((Throwable)sSLException);
            throw raiseException;
        }
    }

    @JRubyMethod
    public IRubyObject write(IRubyObject iRubyObject) {
        byte[] byArray = iRubyObject.convertToString().getBytes();
        this.outboundAppData = new MiniSSLBuffer(byArray);
        return this.getRuntime().newFixnum(byArray.length);
    }

    @JRubyMethod
    public IRubyObject extract(ThreadContext threadContext) {
        try {
            ByteList byteList = this.outboundNetData.asByteList();
            if (byteList != null) {
                return RubyString.newString((Ruby)threadContext.runtime, (ByteList)byteList);
            }
            if (!this.outboundAppData.hasRemaining()) {
                return threadContext.nil;
            }
            this.outboundNetData.clear();
            this.doOp(SSLOperation.WRAP, this.outboundAppData, this.outboundNetData);
            byteList = this.outboundNetData.asByteList();
            if (byteList == null) {
                return threadContext.nil;
            }
            return RubyString.newString((Ruby)threadContext.runtime, (ByteList)byteList);
        }
        catch (SSLException sSLException) {
            RaiseException raiseException = threadContext.runtime.newRuntimeError(sSLException.toString());
            raiseException.initCause((Throwable)sSLException);
            throw raiseException;
        }
    }

    @JRubyMethod
    public IRubyObject peercert() throws CertificateEncodingException {
        try {
            return JavaEmbedUtils.javaToRuby((Ruby)this.getRuntime(), (Object)this.engine.getSession().getPeerCertificates()[0].getEncoded());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return this.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"init?"})
    public IRubyObject isInit(ThreadContext threadContext) {
        return this.handshake ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject shutdown() {
        if (this.closed || this.engine.isInboundDone() && this.engine.isOutboundDone()) {
            if (this.engine.isOutboundDone()) {
                this.engine.closeOutbound();
            }
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private static class MiniSSLBuffer {
        ByteBuffer buffer;

        private MiniSSLBuffer(int n) {
            this.buffer = ByteBuffer.allocate(n);
        }

        private MiniSSLBuffer(byte[] byArray) {
            this.buffer = ByteBuffer.wrap(byArray);
        }

        public void clear() {
            this.buffer.clear();
        }

        public void compact() {
            this.buffer.compact();
        }

        public void flip() {
            ((Buffer)this.buffer).flip();
        }

        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        public int position() {
            return this.buffer.position();
        }

        public ByteBuffer getRawBuffer() {
            return this.buffer;
        }

        private void put(byte[] byArray, int n, int n2) {
            if (this.buffer.remaining() < n2) {
                this.resize(this.buffer.limit() + n2);
            }
            this.buffer.put(byArray, n, n2);
        }

        public void resize(int n) {
            if (n > this.buffer.capacity()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                this.flip();
                byteBuffer.put(this.buffer);
                this.buffer = byteBuffer;
            } else {
                this.buffer.limit(n);
            }
        }

        public ByteList asByteList() {
            this.flip();
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                return null;
            }
            byte[] byArray = new byte[this.buffer.limit()];
            this.buffer.get(byArray);
            this.buffer.clear();
            return new ByteList(byArray, false);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    private static enum SSLOperation {
        WRAP,
        UNWRAP;

    }
}

