/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.serializers.context.NullContextNameStrategy;
import io.confluent.kafka.serializers.context.strategy.ContextNameStrategy;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class AbstractKafkaSchemaSerDeConfig
extends AbstractConfig {
    public static final String REQUEST_HEADER_PREFIX = "request.header.";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to register or look up schemas. If you wish to get a connection to a mocked schema registry for testing, you can specify a scope using the 'mock://' pseudo-protocol. For example, 'mock://my-scope-name' corresponds to 'MockSchemaRegistry.getClientForScope(\"my-scope-name\")'.";
    public static final String MAX_SCHEMAS_PER_SUBJECT_CONFIG = "max.schemas.per.subject";
    public static final int MAX_SCHEMAS_PER_SUBJECT_DEFAULT = 1000;
    public static final String MAX_SCHEMAS_PER_SUBJECT_DOC = "Maximum number of schemas to create or cache locally.";
    public static final String NORMALIZE_SCHEMAS = "normalize.schemas";
    public static final boolean NORMALIZE_SCHEMAS_DEFAULT = false;
    public static final String NORMALIZE_SCHEMAS_DOC = "Whether to normalize schemas, which generally ignores ordering when it is not significant";
    public static final String AUTO_REGISTER_SCHEMAS = "auto.register.schemas";
    public static final boolean AUTO_REGISTER_SCHEMAS_DEFAULT = true;
    public static final String AUTO_REGISTER_SCHEMAS_DOC = "Specify if the Serializer should attempt to register the Schema with Schema Registry";
    public static final String USE_SCHEMA_ID = "use.schema.id";
    public static final int USE_SCHEMA_ID_DEFAULT = -1;
    public static final String USE_SCHEMA_ID_DOC = "Schema ID to use for serialization";
    public static final String ID_COMPATIBILITY_STRICT = "id.compatibility.strict";
    public static final boolean ID_COMPATIBILITY_STRICT_DEFAULT = true;
    public static final String ID_COMPATIBILITY_STRICT_DOC = "Whether to check for backward compatibility between the schema with the given ID and  the schema of the object to be serialized";
    public static final String USE_LATEST_VERSION = "use.latest.version";
    public static final boolean USE_LATEST_VERSION_DEFAULT = false;
    public static final String USE_LATEST_VERSION_DOC = "Specify if the Serializer should use the latest subject version for serialization";
    public static final String USE_LATEST_WITH_METADATA = "use.latest.with.metadata";
    public static final String USE_LATEST_WITH_METADATA_DOC = "Specify if the Serializer or Deserializer should use the latest subject version with the given metadata property and value, for example, 'application.version=v1'";
    public static final String LATEST_COMPATIBILITY_STRICT = "latest.compatibility.strict";
    public static final boolean LATEST_COMPATIBILITY_STRICT_DEFAULT = true;
    public static final String LATEST_COMPATIBILITY_STRICT_DOC = "Whether to check for backward compatibility between the latest subject version and  the schema of the object to be serialized";
    public static final String LATEST_CACHE_SIZE = "latest.cache.size";
    public static final int LATEST_CACHE_SIZE_DEFAULT = 1000;
    public static final String LATEST_CACHE_SIZE_DOC = "The maximum size for caches holding latest schemas";
    public static final String LATEST_CACHE_TTL = "latest.cache.ttl.sec";
    public static final int LATEST_CACHE_TTL_DEFAULT = -1;
    public static final String LATEST_CACHE_TTL_DOC = "The TTL for caches holding latest schemas, or -1 for no TTL";
    public static final String SCHEMA_FORMAT = "schema.format";
    public static final String SCHEMA_FORMAT_DOC = "The schema format to use when registering or looking up schemas.";
    public static final String RULE_EXECUTORS = "rule.executors";
    public static final String RULE_EXECUTORS_DOCS = " A comma-separated list of rule executor names.";
    public static final String RULE_ACTIONS = "rule.actions";
    public static final String RULE_ACTIONS_DOCS = " A comma-separated list of rule action names.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = "URL";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = "STATIC_TOKEN";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String SCHEMA_REGISTRY_USER_INFO_DEFAULT = "";
    public static final String SCHEMA_REGISTRY_USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = "";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = "";
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL = "bearer.auth.issuer.endpoint.url";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL_DOC = "The HTTP(S)-based URL for the OAuth/OIDC identity provider which issues access token";
    public static final String BEARER_AUTH_CLIENT_ID = "bearer.auth.client.id";
    public static final String BEARER_AUTH_CLIENT_ID_DOC = "Client Id used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_CLIENT_SECRET = "bearer.auth.client.secret";
    public static final String BEARER_AUTH_CLIENT_SECRET_DOC = "Client secret used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_SCOPE = "bearer.auth.scope";
    public static final String BEARER_AUTH_SCOPE_DOC = "Access Token Scope used to obtain Client Credentials Grant OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-3.3\"> ";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME = "bearer.auth.scope.claim.name";
    public static final String DEFAULT_BEARER_AUTH_SCOPE_CLAIM_NAME = "scope";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME_DOC = "The OAuth claim for the scope is often named \"scope\", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME = "bearer.auth.sub.claim.name";
    public static final String DEFAULT_BEARER_AUTH_SUB_CLAIM_NAME = "sub";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER = "bearer.auth.logical.cluster";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER_DOC = "Additional property which can added in Request header to Schema Registry";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID = "bearer.auth.identity.pool.id";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID_DOC = "Additional property which can added in Request header to Schema Registry. This maybe used as Principal Id for Authorization";
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS = "bearer.auth.cache.expiry.buffer.seconds";
    public static final Short BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT = 300;
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DOC = "The amount of buffer time between expiration times of the OAuth Token and corresponding cache which hold the token. Ideally we would want to get a new token before the current one expires. Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified. This value is ignored if it exceeds the remaining lifetime of a token from the moment it is retrieved into schema registry.";
    public static final String CONTEXT_NAME_STRATEGY = "context.name.strategy";
    public static final String CONTEXT_NAME_STRATEGY_DEFAULT = NullContextNameStrategy.class.getName();
    public static final String CONTEXT_NAME_STRATEGY_DOC = "A class used to determine the schema registry context.";
    public static final String KEY_SUBJECT_NAME_STRATEGY = "key.subject.name.strategy";
    public static final String KEY_SUBJECT_NAME_STRATEGY_DEFAULT = TopicNameStrategy.class.getName();
    public static final String KEY_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the key schema is registered with the schema registry. By default, <topic>-key is used as subject.";
    public static final String VALUE_SUBJECT_NAME_STRATEGY = "value.subject.name.strategy";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DEFAULT = TopicNameStrategy.class.getName();
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the value schema is registered with the schema registry. By default, <topic>-value is used as subject.";
    public static final String SCHEMA_REFLECTION_CONFIG = "schema.reflection";
    public static final boolean SCHEMA_REFLECTION_DEFAULT = false;
    public static final String SCHEMA_REFLECTION_DOC = "If true, uses the reflection API when serializing/deserializing ";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_HOST_DEFAULT = "";
    public static final String PROXY_HOST_DOC = "The hostname, or address, of the proxy server that will be used to connect to the schema registry instances.";
    public static final String PROXY_PORT = "proxy.port";
    public static final int PROXY_PORT_DEFAULT = -1;
    public static final String PROXY_PORT_DOC = "The port number of the proxy server that will be used to connect to the schema registry instances.";

    public static ConfigDef baseConfigDef() {
        ConfigDef configDef = new ConfigDef().define(SCHEMA_REGISTRY_URL_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, SCHEMA_REGISTRY_URL_DOC).define(MAX_SCHEMAS_PER_SUBJECT_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, MAX_SCHEMAS_PER_SUBJECT_DOC).define(NORMALIZE_SCHEMAS, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, NORMALIZE_SCHEMAS_DOC).define(AUTO_REGISTER_SCHEMAS, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, AUTO_REGISTER_SCHEMAS_DOC).define(USE_SCHEMA_ID, ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.LOW, USE_SCHEMA_ID_DOC).define(ID_COMPATIBILITY_STRICT, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, ID_COMPATIBILITY_STRICT_DOC).define(USE_LATEST_VERSION, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, USE_LATEST_VERSION_DOC).define(LATEST_COMPATIBILITY_STRICT, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, LATEST_COMPATIBILITY_STRICT_DOC).define(LATEST_CACHE_SIZE, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, LATEST_CACHE_SIZE_DOC).define(LATEST_CACHE_TTL, ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.LOW, LATEST_CACHE_TTL_DOC).define(USE_LATEST_WITH_METADATA, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, USE_LATEST_WITH_METADATA_DOC).define(SCHEMA_FORMAT, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, SCHEMA_FORMAT_DOC).define(RULE_EXECUTORS, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, RULE_EXECUTORS_DOCS).define(RULE_ACTIONS, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, RULE_ACTIONS_DOCS).define(BASIC_AUTH_CREDENTIALS_SOURCE, ConfigDef.Type.STRING, (Object)BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, BASIC_AUTH_CREDENTIALS_SOURCE_DOC).define(BEARER_AUTH_CREDENTIALS_SOURCE, ConfigDef.Type.STRING, (Object)BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, BEARER_AUTH_CREDENTIALS_SOURCE_DOC).define(SCHEMA_REGISTRY_USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, SCHEMA_REGISTRY_USER_INFO_DOC).define(USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, SCHEMA_REGISTRY_USER_INFO_DOC).define(BEARER_AUTH_TOKEN_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, BEARER_AUTH_TOKEN_DOC).define(BEARER_AUTH_ISSUER_ENDPOINT_URL, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_ISSUER_ENDPOINT_URL_DOC).define(BEARER_AUTH_CLIENT_ID, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_CLIENT_ID_DOC).define(BEARER_AUTH_CLIENT_SECRET, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_CLIENT_SECRET_DOC).define(BEARER_AUTH_SCOPE, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_SCOPE_DOC).define(BEARER_AUTH_SCOPE_CLAIM_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_BEARER_AUTH_SCOPE_CLAIM_NAME, ConfigDef.Importance.LOW, BEARER_AUTH_SCOPE_CLAIM_NAME_DOC).define(BEARER_AUTH_SUB_CLAIM_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_BEARER_AUTH_SUB_CLAIM_NAME, ConfigDef.Importance.LOW, BEARER_AUTH_SUB_CLAIM_NAME_DOC).define(BEARER_AUTH_IDENTITY_POOL_ID, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_IDENTITY_POOL_ID_DOC).define(BEARER_AUTH_LOGICAL_CLUSTER, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, BEARER_AUTH_LOGICAL_CLUSTER_DOC).define(BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS, ConfigDef.Type.SHORT, (Object)BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)3600), ConfigDef.Importance.LOW, BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DOC).define(CONTEXT_NAME_STRATEGY, ConfigDef.Type.CLASS, (Object)CONTEXT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CONTEXT_NAME_STRATEGY_DOC).define(KEY_SUBJECT_NAME_STRATEGY, ConfigDef.Type.CLASS, (Object)KEY_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, KEY_SUBJECT_NAME_STRATEGY_DOC).define(VALUE_SUBJECT_NAME_STRATEGY, ConfigDef.Type.CLASS, (Object)VALUE_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, VALUE_SUBJECT_NAME_STRATEGY_DOC).define(SCHEMA_REFLECTION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, SCHEMA_REFLECTION_DOC).define(PROXY_HOST, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, PROXY_HOST_DOC).define(PROXY_PORT, ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.LOW, PROXY_PORT_DOC);
        SchemaRegistryClientConfig.withClientSslSupport((ConfigDef)configDef, (String)"schema.registry.");
        return configDef;
    }

    public AbstractKafkaSchemaSerDeConfig(ConfigDef config, Map<?, ?> props) {
        super(config, props);
    }

    public AbstractKafkaSchemaSerDeConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(definition, originals, doLog);
    }

    public int getMaxSchemasPerSubject() {
        return this.getInt(MAX_SCHEMAS_PER_SUBJECT_CONFIG);
    }

    public List<String> getSchemaRegistryUrls() {
        return this.getList(SCHEMA_REGISTRY_URL_CONFIG);
    }

    public boolean normalizeSchema() {
        return this.getBoolean(NORMALIZE_SCHEMAS);
    }

    public boolean autoRegisterSchema() {
        return this.getBoolean(AUTO_REGISTER_SCHEMAS);
    }

    public int useSchemaId() {
        return this.getInt(USE_SCHEMA_ID);
    }

    public boolean getIdCompatibilityStrict() {
        return this.getBoolean(ID_COMPATIBILITY_STRICT);
    }

    public boolean useLatestVersion() {
        return this.getBoolean(USE_LATEST_VERSION);
    }

    public boolean getLatestCompatibilityStrict() {
        return this.getBoolean(LATEST_COMPATIBILITY_STRICT);
    }

    public int getLatestCacheSize() {
        return this.getInt(LATEST_CACHE_SIZE);
    }

    public int getLatestCacheTtl() {
        return this.getInt(LATEST_CACHE_TTL);
    }

    public String getLatestWithMetadataSpec() {
        return this.getString(USE_LATEST_WITH_METADATA);
    }

    public String getSchemaFormat() {
        return this.getString(SCHEMA_FORMAT);
    }

    public ContextNameStrategy contextNameStrategy() {
        return (ContextNameStrategy)this.getConfiguredInstance(CONTEXT_NAME_STRATEGY, ContextNameStrategy.class);
    }

    public Object keySubjectNameStrategy() {
        return this.subjectNameStrategyInstance(KEY_SUBJECT_NAME_STRATEGY);
    }

    public Object valueSubjectNameStrategy() {
        return this.subjectNameStrategyInstance(VALUE_SUBJECT_NAME_STRATEGY);
    }

    public boolean useSchemaReflection() {
        return this.getBoolean(SCHEMA_REFLECTION_CONFIG);
    }

    public Map<String, String> requestHeaders() {
        return this.originalsWithPrefix(REQUEST_HEADER_PREFIX).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.toString(entry.getValue())));
    }

    private Object subjectNameStrategyInstance(String config) {
        Class<SubjectNameStrategy> deprecatedClass = SubjectNameStrategy.class;
        Class subjectNameStrategyClass = this.getClass(config);
        if (deprecatedClass.isAssignableFrom(subjectNameStrategyClass)) {
            return this.getConfiguredInstance(config, deprecatedClass);
        }
        return this.getConfiguredInstance(config, io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy.class);
    }

    public String basicAuthUserInfo() {
        String deprecatedValue = this.getString(SCHEMA_REGISTRY_USER_INFO_CONFIG);
        if (deprecatedValue != null && !deprecatedValue.isEmpty()) {
            return deprecatedValue;
        }
        return this.getString(USER_INFO_CONFIG);
    }
}

